/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.image.pathdata;

import ej.microvg.image.ImageGenerator;
import ej.microvg.image.pathdata.PathData;
import java.io.ByteArrayOutputStream;

public class TwoArraysPathData
implements PathData {
    private final ByteArrayOutputStream commandsBuffer = new ByteArrayOutputStream();
    private final ByteArrayOutputStream coordinatesBuffer = new ByteArrayOutputStream();

    @Override
    public void reset() {
        this.commandsBuffer.reset();
        this.coordinatesBuffer.reset();
    }

    @Override
    public ImageGenerator.Format getFormat() {
        return ImageGenerator.Format.VG_FP32;
    }

    @Override
    public void appendCommand(int command) {
        this.commandsBuffer.write((byte)command);
    }

    @Override
    public void appendCoordinate(double coordinate) {
        int i = Float.floatToIntBits((float)coordinate);
        this.append(this.coordinatesBuffer, i);
    }

    private void append(ByteArrayOutputStream buffer, int i) {
        buffer.write((byte)i);
        buffer.write((byte)(i >> 8));
        buffer.write((byte)(i >> 16));
        buffer.write((byte)(i >> 24));
    }

    public byte[] getPathParams() {
        return this.coordinatesBuffer.toByteArray();
    }

    public byte[] getPathCommands() {
        return this.commandsBuffer.toByteArray();
    }
}

