/*
 * Decompiled with CFR 0.152.
 */
package ej.trace;

import java.util.Iterator;
import java.util.ServiceLoader;

public class Tracer {
    private static TracerService tracer;
    private final int groupId;

    private static TracerService getTracer() {
        if (tracer == null) {
            ServiceLoader<TracerService> hilLoader = ServiceLoader.load(TracerService.class, Tracer.class.getClassLoader());
            Iterator<TracerService> it = hilLoader.iterator();
            tracer = it.hasNext() ? it.next() : new TracerService(){};
        }
        return tracer;
    }

    public static void startTrace() {
        Tracer.getTracer().startTrace();
    }

    public static void stopTrace() {
        Tracer.getTracer().stopTrace();
    }

    public static boolean isTraceStarted() {
        return Tracer.getTracer().isTraceStarted();
    }

    public static int registerGroup(byte[] groupNameBuffer, int nbEventTypes) {
        return Tracer.getTracer().registerGroup(groupNameBuffer, nbEventTypes);
    }

    public static void recordEventNative(int groupId, int eventId) {
        Tracer.getTracer().recordEvent(groupId, eventId, new int[0]);
    }

    public static void recordEventNative(int groupId, int eventId, int value1) {
        Tracer.getTracer().recordEvent(groupId, eventId, value1);
    }

    public static void recordEventNative(int groupId, int eventId, int value1, int value2) {
        Tracer.getTracer().recordEvent(groupId, eventId, value1, value2);
    }

    public static void recordEventNative(int groupId, int eventId, int value1, int value2, int value3) {
        Tracer.getTracer().recordEvent(groupId, eventId, value1, value2, value3);
    }

    public static void recordEventNative(int groupId, int eventId, int value1, int value2, int value3, int value4) {
        Tracer.getTracer().recordEvent(groupId, eventId, value1, value2, value3, value4);
    }

    public static void recordEventNative(int groupId, int eventId, int value1, int value2, int value3, int value4, int value5) {
        Tracer.getTracer().recordEvent(groupId, eventId, value1, value2, value3, value4, value5);
    }

    public static void recordEventNative(int groupId, int eventId, int value1, int value2, int value3, int value4, int value5, int value6) {
        Tracer.getTracer().recordEvent(groupId, eventId, value1, value2, value3, value4, value5, value6);
    }

    public static void recordEventNative(int groupId, int eventId, int value1, int value2, int value3, int value4, int value5, int value6, int value7) {
        Tracer.getTracer().recordEvent(groupId, eventId, value1, value2, value3, value4, value5, value6, value7);
    }

    public static void recordEventNative(int groupId, int eventId, int value1, int value2, int value3, int value4, int value5, int value6, int value7, int value8) {
        Tracer.getTracer().recordEvent(groupId, eventId, value1, value2, value3, value4, value5, value6, value7, value8);
    }

    public static void recordEventNative(int groupId, int eventId, int value1, int value2, int value3, int value4, int value5, int value6, int value7, int value8, int value9) {
        Tracer.getTracer().recordEvent(groupId, eventId, value1, value2, value3, value4, value5, value6, value7, value8, value9);
    }

    public static void recordEventNative(int groupId, int eventId, int value1, int value2, int value3, int value4, int value5, int value6, int value7, int value8, int value9, int value10) {
        Tracer.getTracer().recordEvent(groupId, eventId, value1, value2, value3, value4, value5, value6, value7, value8, value9, value10);
    }

    public static void recordEventEndNative(int groupId, int eventId) {
        Tracer.getTracer().recordEventEnd(groupId, eventId, new int[0]);
    }

    public static void recordEventEndNative(int groupId, int eventId, int value1) {
        Tracer.getTracer().recordEventEnd(groupId, eventId, value1);
    }

    public Tracer(String name, int nbEventTypes) throws InternalError {
        this.groupId = Tracer.getTracer().registerGroup(name, nbEventTypes);
    }

    public int getGroupID() {
        return this.groupId;
    }

    public void recordEvent(int eventId) {
        Tracer.recordEventNative(this.groupId, eventId);
    }

    public void recordEvent(int eventId, int value1) {
        Tracer.recordEventNative(this.groupId, eventId, value1);
    }

    public void recordEvent(int eventId, int value1, int value2) {
        Tracer.recordEventNative(this.groupId, eventId, value1, value2);
    }

    public void recordEvent(int eventId, int value1, int value2, int value3) {
        Tracer.recordEventNative(this.groupId, eventId, value1, value2, value3);
    }

    public void recordEvent(int eventId, int value1, int value2, int value3, int value4) {
        Tracer.recordEventNative(this.groupId, eventId, value1, value2, value3, value4);
    }

    public void recordEvent(int eventId, int value1, int value2, int value3, int value4, int value5) {
        Tracer.recordEventNative(this.groupId, eventId, value1, value2, value3, value4, value5);
    }

    public void recordEvent(int eventId, int value1, int value2, int value3, int value4, int value5, int value6) {
        Tracer.recordEventNative(this.groupId, eventId, value1, value2, value3, value4, value5, value6);
    }

    public void recordEvent(int eventId, int value1, int value2, int value3, int value4, int value5, int value6, int value7) {
        Tracer.recordEventNative(this.groupId, eventId, value1, value2, value3, value4, value5, value6, value7);
    }

    public void recordEvent(int eventId, int value1, int value2, int value3, int value4, int value5, int value6, int value7, int value8) {
        Tracer.recordEventNative(this.groupId, eventId, value1, value2, value3, value4, value5, value6, value7, value8);
    }

    public void recordEvent(int eventId, int value1, int value2, int value3, int value4, int value5, int value6, int value7, int value8, int value9) {
        Tracer.recordEventNative(this.groupId, eventId, value1, value2, value3, value4, value5, value6, value7, value8, value9);
    }

    public void recordEvent(int eventId, int value1, int value2, int value3, int value4, int value5, int value6, int value7, int value8, int value9, int value10) {
        Tracer.recordEventNative(this.groupId, eventId, value1, value2, value3, value4, value5, value6, value7, value8, value9, value10);
    }

    public void recordEvent(int eventId, int ... values) {
        Tracer.getTracer().recordEvent(this.getGroupID(), eventId, values);
    }

    public void recordEventEnd(int eventId) {
        Tracer.recordEventEndNative(this.groupId, eventId);
    }

    public void recordEventEnd(int eventId, int value1) {
        Tracer.recordEventEndNative(this.groupId, eventId, value1);
    }

    public void recordEventEnd(int eventId, int ... values) {
        Tracer.getTracer().recordEventEnd(this.getGroupID(), eventId, values);
    }

    public static interface TracerService {
        default public void startTrace() {
        }

        default public void stopTrace() {
        }

        default public boolean isTraceStarted() {
            return false;
        }

        default public int registerGroup(byte[] groupNameBuffer, int nbEventTypes) {
            return 0;
        }

        default public int registerGroup(String groupName, int nbEventTypes) {
            return 0;
        }

        default public void recordEvent(int groupId, int eventId, int ... values) {
        }

        default public void recordEventEnd(int groupId, int eventId, int ... values) {
        }
    }
}

