/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt.animation;

import ej.basictool.ArrayTools;
import ej.basictool.ThreadUtils;
import ej.bon.Util;
import ej.microui.MicroUI;
import ej.microui.display.Display;
import ej.mwt.animation.Animation;

public class Animator {
    private final Object monitor = new Object();
    private Animation[] animations = new Animation[0];
    private boolean hasChanged = true;
    private Animation[] animationsCache = new Animation[0];
    private boolean started;
    private boolean stopRequested;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAnimation(Animation animation) {
        Object object = this.monitor;
        synchronized (object) {
            this.animations = (Animation[])ArrayTools.add((Object[])this.animations, (Object)animation);
            this.hasChanged = true;
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAnimation(Animation animation) {
        Object object = this.monitor;
        synchronized (object) {
            this.animations = (Animation[])ArrayTools.remove((Object[])this.animations, (Object)animation);
            this.hasChanged = true;
            if (this.animations.length == 0) {
                this.stopRequested = true;
                this.animationsCache = new Animation[0];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Animation[] getAnimations() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.hasChanged) {
                this.hasChanged = false;
                this.animationsCache = (Animation[])this.animations.clone();
            }
        }
        return this.animationsCache;
    }

    private void tick() {
        Animation[] animations;
        long currentTimeMillis = Util.platformTimeMillis();
        Animation[] animationArray = animations = this.getAnimations();
        int n = animations.length;
        int n2 = 0;
        while (n2 < n) {
            Animation animation = animationArray[n2];
            assert (animation != null);
            try {
                if (!animation.tick(currentTimeMillis)) {
                    this.stopAnimation(animation);
                }
            }
            catch (Exception e) {
                ThreadUtils.handleUncaughtException((Exception)e);
                this.stopAnimation(animation);
            }
            ++n2;
        }
    }

    private void start() {
        this.stopRequested = false;
        if (!this.started) {
            this.started = true;
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    Animator.this.runTick(this);
                }
            };
            MicroUI.callSerially((Runnable)run);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTick(Runnable runnable) {
        boolean restart;
        this.tick();
        Object object = this.monitor;
        synchronized (object) {
            if (this.stopRequested) {
                this.started = false;
                restart = false;
            } else {
                restart = true;
            }
        }
        if (restart) {
            Display display = Display.getDisplay();
            display.requestFlush();
            display.callOnFlushCompleted(runnable);
        }
    }
}

