/*
 * Decompiled with CFR 0.152.
 */
package ej.library.iot.rcommand.bluetooth.commands;

import ej.annotation.Nullable;
import ej.bluetooth.BluetoothConnection;
import ej.bluetooth.BluetoothUuid;
import ej.library.iot.rcommand.bluetooth.BluetoothController;
import ej.rcommand.CommandReader;
import ej.rcommand.CommandSender;
import ej.rcommand.synchronous.Endpoint;
import java.io.IOException;

public class DiscoverServicesEndpoint
implements Endpoint {
    private final BluetoothController controller;
    private short connHandle;
    @Nullable
    private byte[] uuid;

    public DiscoverServicesEndpoint(BluetoothController controller) {
        this.controller = controller;
    }

    public String getName() {
        return "bluetooth_discover_services";
    }

    public void readRequestBody(CommandReader reader) throws IOException {
        this.connHandle = (short)reader.readInt();
        byte[] uuid = reader.readByteArray();
        this.uuid = (byte[])(uuid.length != 0 ? uuid : null);
    }

    public void writeResponseBody(CommandSender sender) throws IOException {
        boolean success;
        BluetoothConnection connection = this.controller.getConnection(this.connHandle);
        if (connection == null) {
            success = false;
        } else {
            byte[] uuid = this.uuid;
            if (uuid == null) {
                success = connection.discoverServices();
            } else {
                BluetoothUuid uuidObject = new BluetoothUuid(uuid, 0);
                success = connection.discoverService(uuidObject);
            }
        }
        if (success) {
            sender.sendInt(0);
        } else {
            sender.sendInt(1);
        }
    }
}

