/*
 * Decompiled with CFR 0.152.
 */
package ej.library.iot.rcommand.bluetooth;

import ej.annotation.Nullable;
import ej.bluetooth.BluetoothAdapter;
import ej.bluetooth.BluetoothAttribute;
import ej.bluetooth.BluetoothConnection;
import ej.bluetooth.BluetoothService;
import ej.bluetooth.listeners.ConnectionListener;
import ej.bluetooth.listeners.LocalServiceListener;
import ej.bluetooth.listeners.RemoteServiceListener;
import ej.library.iot.rcommand.bluetooth.BluetoothDatabase;
import ej.library.iot.rcommand.bluetooth.EventSerializer;
import ej.library.iot.rcommand.bluetooth.commands.AddServiceEndpoint;
import ej.library.iot.rcommand.bluetooth.commands.ConnectEndpoint;
import ej.library.iot.rcommand.bluetooth.commands.DisableEndpoint;
import ej.library.iot.rcommand.bluetooth.commands.DisconnectEndpoint;
import ej.library.iot.rcommand.bluetooth.commands.DiscoverServicesEndpoint;
import ej.library.iot.rcommand.bluetooth.commands.EnableEndpoint;
import ej.library.iot.rcommand.bluetooth.commands.PollEventEndpoint;
import ej.library.iot.rcommand.bluetooth.commands.SendExecuteWriteResponseEndpoint;
import ej.library.iot.rcommand.bluetooth.commands.SendNotificationEndpoint;
import ej.library.iot.rcommand.bluetooth.commands.SendPairRequestEndpoint;
import ej.library.iot.rcommand.bluetooth.commands.SendPairResponseEndpoint;
import ej.library.iot.rcommand.bluetooth.commands.SendPasskeyResponseEndpoint;
import ej.library.iot.rcommand.bluetooth.commands.SendPrepareWriteResponseEndpoint;
import ej.library.iot.rcommand.bluetooth.commands.SendReadRequestEndpoint;
import ej.library.iot.rcommand.bluetooth.commands.SendReadResponseEndpoint;
import ej.library.iot.rcommand.bluetooth.commands.SendWriteRequestEndpoint;
import ej.library.iot.rcommand.bluetooth.commands.SendWriteResponseEndpoint;
import ej.library.iot.rcommand.bluetooth.commands.StartAdvertisingEndpoint;
import ej.library.iot.rcommand.bluetooth.commands.StartScanningEndpoint;
import ej.library.iot.rcommand.bluetooth.commands.StopAdvertisingEndpoint;
import ej.library.iot.rcommand.bluetooth.commands.StopScanningEndpoint;
import ej.library.iot.rcommand.bluetooth.notifications.EventAvailableNotification;
import ej.rcommand.RemoteCommandListener;
import ej.rcommand.RemoteCommandManager;
import ej.rcommand.RemoteNotification;
import ej.rcommand.synchronous.Endpoint;
import ej.rcommand.synchronous.EndpointListener;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;

public class BluetoothController {
    private static final int EVENT_QUEUE_SIZE = 10;
    private static final BluetoothController INSTANCE = new BluetoothController();
    private final Deque<byte[]> eventQueue = new ArrayDeque<byte[]>();
    private final EventSerializer eventSerializer = new EventSerializer(this);
    private final BluetoothDatabase database = new BluetoothDatabase();
    private final Map<BluetoothConnection, Short> connections = new HashMap<BluetoothConnection, Short>();
    private final Map<BluetoothConnection, BluetoothDatabase> connectionDatabases = new HashMap<BluetoothConnection, BluetoothDatabase>();
    private short connectionHandleCounter = 1;
    private short attributeHandleCounter = 1;
    @Nullable
    private RemoteCommandManager rcommandManager;

    private BluetoothController() {
    }

    public static BluetoothController getInstance() {
        return INSTANCE;
    }

    public void setup(RemoteCommandManager rcommandManager) {
        Endpoint[] endpoints;
        Endpoint[] endpointArray = endpoints = new Endpoint[]{new PollEventEndpoint(this), new EnableEndpoint(this), new DisableEndpoint(this), new StartScanningEndpoint(), new StopScanningEndpoint(), new StartAdvertisingEndpoint(), new StopAdvertisingEndpoint(), new ConnectEndpoint(), new DisconnectEndpoint(this), new SendPairRequestEndpoint(this), new SendPairResponseEndpoint(this), new SendPasskeyResponseEndpoint(this), new DiscoverServicesEndpoint(this), new AddServiceEndpoint(this), new SendReadRequestEndpoint(this), new SendWriteRequestEndpoint(this), new SendReadResponseEndpoint(this), new SendWriteResponseEndpoint(this), new SendPrepareWriteResponseEndpoint(this), new SendExecuteWriteResponseEndpoint(this), new SendNotificationEndpoint(this)};
        int n = endpoints.length;
        int n2 = 0;
        while (n2 < n) {
            Endpoint endpoint = endpointArray[n2];
            assert (endpoint != null);
            rcommandManager.registerListener((RemoteCommandListener)new EndpointListener(endpoint));
            ++n2;
        }
        this.rcommandManager = rcommandManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public byte[] pollEvent() {
        Deque<byte[]> deque = this.eventQueue;
        synchronized (deque) {
            byte[] event = this.eventQueue.poll();
            if (event != null) {
                this.eventQueue.notifyAll();
            }
            return event;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(byte[] event) {
        RemoteCommandManager rcommandManager = this.rcommandManager;
        if (rcommandManager != null) {
            Deque<byte[]> deque = this.eventQueue;
            synchronized (deque) {
                while (this.eventQueue.size() >= 10) {
                    try {
                        this.eventQueue.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
                this.eventQueue.add(event);
                this.eventQueue.notifyAll();
            }
            EventAvailableNotification notification = new EventAvailableNotification();
            rcommandManager.sendNotification((RemoteNotification)notification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public BluetoothConnection getConnection(short connHandle) {
        BluetoothController bluetoothController = this;
        synchronized (bluetoothController) {
            for (Map.Entry<BluetoothConnection, Short> entry : this.connections.entrySet()) {
                Short handle = entry.getValue();
                assert (handle != null);
                if (handle != connHandle) continue;
                return entry.getKey();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Short getConnHandle(BluetoothConnection connection) {
        BluetoothController bluetoothController = this;
        synchronized (bluetoothController) {
            return this.connections.get(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public BluetoothAttribute getLocalAttribute(short attributeHandle) {
        BluetoothController bluetoothController = this;
        synchronized (bluetoothController) {
            return this.database.getAttribute(attributeHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Short getLocalAttributeHandle(BluetoothAttribute attribute) {
        BluetoothController bluetoothController = this;
        synchronized (bluetoothController) {
            return this.database.getAttributeHandle(attribute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public BluetoothAttribute getRemoteAttribute(@Nullable BluetoothConnection connection, short attributeHandle) {
        if (connection == null) {
            return null;
        }
        BluetoothController bluetoothController = this;
        synchronized (bluetoothController) {
            BluetoothDatabase database = this.connectionDatabases.get(connection);
            if (database != null) {
                return database.getAttribute(attributeHandle);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Short getRemoteAttributeHandle(BluetoothConnection connection, BluetoothAttribute attribute) {
        BluetoothController bluetoothController = this;
        synchronized (bluetoothController) {
            BluetoothDatabase database = this.connectionDatabases.get(connection);
            if (database != null) {
                return database.getAttributeHandle(attribute);
            }
            return null;
        }
    }

    public void onAdapterEnabled() {
        BluetoothAdapter.getAdapter().setConnectionListener((ConnectionListener)this.eventSerializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAdapterDisabled() {
        Object object = this.eventQueue;
        synchronized (object) {
            this.eventQueue.clear();
            this.eventQueue.notifyAll();
        }
        object = this;
        synchronized (object) {
            this.database.clear();
            this.connections.clear();
            this.connectionDatabases.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short onConnected(BluetoothConnection connection) {
        BluetoothController bluetoothController = this;
        synchronized (bluetoothController) {
            short connHandle = this.connectionHandleCounter;
            this.connectionHandleCounter = (short)(this.connectionHandleCounter + 1);
            this.connections.put(connection, connHandle);
            this.connectionDatabases.put(connection, new BluetoothDatabase());
            return connHandle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Short onDisconnected(BluetoothConnection connection) {
        BluetoothController bluetoothController = this;
        synchronized (bluetoothController) {
            this.connectionDatabases.remove(connection);
            return this.connections.remove(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServiceAdded(BluetoothService service, short[] handles) {
        service.setLocalListener((LocalServiceListener)this.eventSerializer);
        BluetoothController bluetoothController = this;
        synchronized (bluetoothController) {
            this.attributeHandleCounter = this.database.addService(service, this.attributeHandleCounter, handles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Short onServiceDiscovered(BluetoothConnection connection, BluetoothService service) {
        service.setRemoteListener((RemoteServiceListener)this.eventSerializer);
        BluetoothController bluetoothController = this;
        synchronized (bluetoothController) {
            BluetoothDatabase database = this.connectionDatabases.get(connection);
            if (database != null) {
                Short identicalServiceHandle = database.getServiceHandle(service);
                if (identicalServiceHandle == null) {
                    this.attributeHandleCounter = database.addService(service, this.attributeHandleCounter, null);
                    return this.attributeHandleCounter;
                }
                return identicalServiceHandle;
            }
        }
        return null;
    }
}

