/*
 * Decompiled with CFR 0.152.
 */
package com.microej.nls;

import com.microej.nls.Locale;
import com.microej.nls.NLSPlural;
import ej.annotation.Nullable;
import ej.bon.ResourceArray;
import ej.bon.ResourceBuffer;
import ej.nls.NLS;
import ej.util.message.MessageBuilder;
import ej.util.message.MessageLogger;
import ej.util.message.basic.BasicMessageBuilder;
import ej.util.message.basic.BasicMessageLogger;
import java.io.IOException;

public class BinaryNLS
implements NLS {
    private static final int FORMAT_VERSION = 1;
    public static final String NLS_DEFAULT_LOCALE = "com.microej.binarynls.defaultLocale";
    public static final String NLS_DEFAULT_IMPLEMENTATION = "com.microej.binarynls.defaultImplementation";
    private static final String NLS_PO_CATEGORY = "NLS-PO";
    public static final int MISSING_BINARY = 1;
    public static final int WRONG_HEADER = 2;
    public static final int WRONG_FORMAT_VERSION = 3;
    public static final int WRONG_CRC = 4;
    public static final int DEFAULT_IMPLEMENTATION_ERROR = 5;
    public static final int REQUIRED_IMPLEMENTATION_ERROR = 6;
    public static final int WRONG_LOCALE_INDEX = 7;
    public static final int FORM_INDEX_OUT_OF_BOUNDS_ERROR = 8;
    private static final MessageBuilder ERROR_MESSAGE_BUILDER = new BasicMessageBuilder();
    private static final MessageLogger ERROR_MESSAGE_LOGGER = new BasicMessageLogger(ERROR_MESSAGE_BUILDER);
    private final ResourceArray localesArray;
    private final String[] localesNames;
    private Locale currentLocale;
    @Nullable
    private final NLSPlural pluralInfo;

    @Nullable
    public static NLS newBinaryNLS(String nlsInterfaceName, int keysCRC32, NLSPlural pluralInfo) {
        return BinaryNLS.newBinaryNLSInternal(nlsInterfaceName, keysCRC32, pluralInfo);
    }

    @Nullable
    public static NLS newBinaryNLS(String nlsInterfaceName, int keysCRC32) {
        return BinaryNLS.newBinaryNLSInternal(nlsInterfaceName, keysCRC32, null);
    }

    @Nullable
    private static NLS newBinaryNLSInternal(String nlsInterfaceName, int keysCRC32, @Nullable NLSPlural pluralInfo) {
        try {
            return new BinaryNLS(nlsInterfaceName, keysCRC32, pluralInfo);
        }
        catch (IOException e) {
            ERROR_MESSAGE_LOGGER.log('I', NLS_PO_CATEGORY, 6, (Throwable)e);
            return BinaryNLS.createDefaultImplementation();
        }
    }

    @Nullable
    private static NLS createDefaultImplementation() {
        String implementationName = System.getProperty(NLS_DEFAULT_IMPLEMENTATION);
        if (implementationName != null) {
            try {
                return (NLS)Class.forName(implementationName).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                throw new IllegalArgumentException(ERROR_MESSAGE_BUILDER.buildMessage('S', NLS_PO_CATEGORY, 5, new Object[]{implementationName}));
            }
        }
        return null;
    }

    public BinaryNLS(String nlsInterfaceName, int keysCRC32, @Nullable NLSPlural pluralInfo) throws IOException {
        ResourceArray localesArray;
        ResourceBuffer buf = this.loadBinFile(nlsInterfaceName, keysCRC32);
        this.localesArray = localesArray = buf.readArray();
        this.localesNames = this.loadLocales(this.localesArray);
        this.currentLocale = this.getDefaultLocale();
        this.pluralInfo = pluralInfo;
    }

    public BinaryNLS(String nlsInterfaceName, int keysCRC32) throws IOException {
        this(nlsInterfaceName, keysCRC32, null);
    }

    public BinaryNLS(Class<? extends Object> nlsInterface, int keysCRC32) throws IOException {
        this(nlsInterface.getName(), keysCRC32);
    }

    public String getDisplayName(String locale) {
        return this.getMessage(0, locale);
    }

    public String getMessage(int messageID) {
        return this.getMessageFormForCount(messageID, 1, this.currentLocale);
    }

    public String getMessage(int messageID, int count) {
        return this.getMessageFormForCount(messageID, count, this.currentLocale);
    }

    public String getMessage(int messageID, String locale) {
        try {
            return this.getMessageFormForCount(messageID, 1, this.getLocale(locale));
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
    }

    public String getMessage(int messageID, int count, String locale) {
        try {
            return this.getMessageFormForCount(messageID, count, this.getLocale(locale));
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
    }

    private String getMessageFormForCount(int messageID, int count, Locale locale) {
        try {
            NLSPlural pluralInfo = this.pluralInfo;
            if (pluralInfo != null) {
                return locale.getMessage(messageID + pluralInfo.processCount(messageID, count, locale.index));
            }
            return locale.getMessage(messageID);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException();
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
    }

    public void setCurrentLocale(String locale) {
        if (!locale.equals(this.localesNames[this.currentLocale.index])) {
            try {
                this.currentLocale = this.getLocale(locale);
            }
            catch (IOException iOException) {}
        }
    }

    public String[] getAvailableLocales() {
        int l = this.localesNames.length;
        String[] out = new String[l];
        System.arraycopy(this.localesNames, 0, out, 0, l);
        return out;
    }

    public String getCurrentLocale() {
        String locale = this.localesNames[this.currentLocale.index];
        return locale;
    }

    private Locale getDefaultLocale() throws IOException, IllegalArgumentException {
        String defaultLocale = System.getProperty(NLS_DEFAULT_LOCALE);
        if (defaultLocale != null) {
            try {
                return this.getLocale(defaultLocale);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (this.localesNames.length == 0) {
            throw new RuntimeException();
        }
        return this.getLocale(0);
    }

    private String[] loadLocales(ResourceArray localesArray) throws IOException {
        int nbLocales = localesArray.length();
        String[] locales = new String[nbLocales];
        int i = -1;
        while (++i < nbLocales) {
            ResourceBuffer buf = localesArray.seekToElementPointer(i);
            buf.readArray();
            buf.align(4);
            locales[i] = buf.readString();
        }
        return locales;
    }

    private ResourceBuffer loadBinFile(String nlsInterfaceName, int keysCRC32) throws IOException {
        ResourceBuffer rb;
        String binFilePath = String.valueOf('/') + nlsInterfaceName.replace('.', '/') + ".nls";
        try {
            rb = new ResourceBuffer(binFilePath);
        }
        catch (IOException iOException) {
            throw new IOException(ERROR_MESSAGE_BUILDER.buildMessage('S', NLS_PO_CATEGORY, 1));
        }
        if (rb.readByte() != 77 || rb.readByte() != 69 || rb.readByte() != 74 || rb.readByte() != 95 || rb.readByte() != 78 || rb.readByte() != 76 || rb.readByte() != 83) {
            throw new IOException(ERROR_MESSAGE_BUILDER.buildMessage('S', NLS_PO_CATEGORY, 2));
        }
        byte readFormat = rb.readByte();
        if (readFormat != 1) {
            throw new IOException(ERROR_MESSAGE_BUILDER.buildMessage('S', NLS_PO_CATEGORY, 3, new Object[]{new Integer(readFormat), new Integer(1)}));
        }
        int readCRC = rb.readInt();
        if (readCRC != keysCRC32) {
            throw new IOException(ERROR_MESSAGE_BUILDER.buildMessage('S', NLS_PO_CATEGORY, 4, new Object[]{new Integer(readCRC), new Integer(keysCRC32)}));
        }
        return rb;
    }

    private int getLocaleIndex(String locale) throws IOException {
        String[] locales = this.localesNames;
        int i = locales.length;
        while (--i >= 0) {
            if (!locales[i].equals(locale)) continue;
            return i;
        }
        throw new IOException();
    }

    private Locale getLocale(String locale) throws IOException {
        return this.getLocale(this.getLocaleIndex(locale));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Locale getLocale(int localeIndex) throws IOException {
        ResourceBuffer resourceBuffer = this.localesArray.getBuffer();
        synchronized (resourceBuffer) {
            ResourceArray array = this.localesArray.seekToElementPointer(localeIndex).readArray();
            return new Locale(localeIndex, array);
        }
    }

    public static String getErrorMessage(int errorCode) {
        return ERROR_MESSAGE_BUILDER.buildMessage('S', NLS_PO_CATEGORY, errorCode);
    }
}

