/*
 * Decompiled with CFR 0.152.
 */
package java.time.zone;

import ej.annotation.Nullable;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneOffsetTransitionRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ZoneRules
implements Serializable {
    private final long[] standardTransitions;
    private final ZoneOffset[] standardOffsets;
    private final long[] savingsInstantTransitions;
    private LocalDateTime[] savingsLocalTransitions;
    private final ZoneOffset[] wallOffsets;
    private final ZoneOffsetTransitionRule[] lastRules;
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final ZoneOffsetTransitionRule[] EMPTY_LASTRULES = new ZoneOffsetTransitionRule[0];
    private static final LocalDateTime[] EMPTY_LDT_ARRAY = new LocalDateTime[0];

    public static ZoneRules of(ZoneOffset baseStandardOffset, ZoneOffset baseWallOffset, List<ZoneOffsetTransition> standardOffsetTransitionList, List<ZoneOffsetTransition> transitionList, List<ZoneOffsetTransitionRule> lastRules) {
        return new ZoneRules(baseStandardOffset, baseWallOffset, standardOffsetTransitionList, transitionList, lastRules);
    }

    public static ZoneRules of(ZoneOffset offset) {
        return new ZoneRules(offset);
    }

    ZoneRules(ZoneOffset baseStandardOffset, ZoneOffset baseWallOffset, List<ZoneOffsetTransition> standardOffsetTransitionList, List<ZoneOffsetTransition> transitionList, List<ZoneOffsetTransitionRule> lastRules) {
        this.standardTransitions = new long[standardOffsetTransitionList.size()];
        this.standardOffsets = new ZoneOffset[standardOffsetTransitionList.size() + 1];
        this.standardOffsets[0] = baseStandardOffset;
        int i = 0;
        while (i < standardOffsetTransitionList.size()) {
            this.standardTransitions[i] = standardOffsetTransitionList.get(i).toEpochSecond();
            this.standardOffsets[i + 1] = standardOffsetTransitionList.get(i).getOffsetAfter();
            ++i;
        }
        ArrayList<LocalDateTime> localTransitionList = new ArrayList<LocalDateTime>();
        ArrayList<ZoneOffset> localTransitionOffsetList = new ArrayList<ZoneOffset>();
        localTransitionOffsetList.add(baseWallOffset);
        for (ZoneOffsetTransition trans : transitionList) {
            if (trans.isGap()) {
                localTransitionList.add(trans.getDateTimeBefore());
                localTransitionList.add(trans.getDateTimeAfter());
            } else {
                localTransitionList.add(trans.getDateTimeAfter());
                localTransitionList.add(trans.getDateTimeBefore());
            }
            localTransitionOffsetList.add(trans.getOffsetAfter());
        }
        this.savingsLocalTransitions = localTransitionList.toArray(new LocalDateTime[localTransitionList.size()]);
        this.wallOffsets = localTransitionOffsetList.toArray(new ZoneOffset[localTransitionOffsetList.size()]);
        this.savingsInstantTransitions = new long[transitionList.size()];
        int i2 = 0;
        while (i2 < transitionList.size()) {
            this.savingsInstantTransitions[i2] = transitionList.get(i2).toEpochSecond();
            ++i2;
        }
        if (lastRules.size() > 16) {
            throw new IllegalArgumentException("Too many transition rules");
        }
        this.lastRules = lastRules.toArray(new ZoneOffsetTransitionRule[lastRules.size()]);
    }

    ZoneRules(long[] standardTransitions, ZoneOffset[] standardOffsets, long[] savingsInstantTransitions, ZoneOffset[] wallOffsets, ZoneOffsetTransitionRule[] lastRules) {
        this.standardTransitions = standardTransitions;
        this.standardOffsets = standardOffsets;
        this.savingsInstantTransitions = savingsInstantTransitions;
        this.wallOffsets = wallOffsets;
        this.lastRules = lastRules;
        this.savingsLocalTransitions = EMPTY_LDT_ARRAY;
    }

    private ZoneRules(ZoneOffset offset) {
        this.standardOffsets = new ZoneOffset[1];
        this.standardOffsets[0] = offset;
        this.standardTransitions = EMPTY_LONG_ARRAY;
        this.savingsInstantTransitions = EMPTY_LONG_ARRAY;
        this.savingsLocalTransitions = EMPTY_LDT_ARRAY;
        this.wallOffsets = this.standardOffsets;
        this.lastRules = EMPTY_LASTRULES;
    }

    public boolean isFixedOffset() {
        return this.savingsInstantTransitions.length == 0;
    }

    public ZoneOffset getOffset(Instant instant) {
        if (this.savingsInstantTransitions.length == 0) {
            ZoneOffset zoneOffset = this.standardOffsets[0];
            assert (zoneOffset != null);
            return zoneOffset;
        }
        long epochSec = instant.getEpochSecond();
        if (this.lastRules.length > 0 && epochSec > this.savingsInstantTransitions[this.savingsInstantTransitions.length - 1]) {
            ZoneOffset offset = this.wallOffsets[this.wallOffsets.length - 1];
            assert (offset != null);
            int year = this.findYear(epochSec, offset);
            ZoneOffsetTransition[] transArray = this.findTransitionArray(year);
            ZoneOffsetTransition trans = null;
            assert (transArray != null);
            int i = 0;
            while (i < transArray.length) {
                trans = transArray[i];
                if (epochSec < trans.toEpochSecond()) {
                    return trans.getOffsetBefore();
                }
                ++i;
            }
            assert (trans != null);
            return trans.getOffsetAfter();
        }
        int index = Arrays.binarySearch(this.savingsInstantTransitions, epochSec);
        if (index < 0) {
            index = -index - 2;
        }
        ZoneOffset zoneOffset = this.wallOffsets[index + 1];
        assert (zoneOffset != null);
        return zoneOffset;
    }

    public ZoneOffset getOffset(LocalDateTime localDateTime) {
        Object info = this.getOffsetInfo(localDateTime);
        if (info instanceof ZoneOffsetTransition) {
            return ((ZoneOffsetTransition)info).getOffsetBefore();
        }
        return (ZoneOffset)info;
    }

    public List<ZoneOffset> getValidOffsets(LocalDateTime localDateTime) {
        Object info = this.getOffsetInfo(localDateTime);
        if (info instanceof ZoneOffsetTransition) {
            return ((ZoneOffsetTransition)info).getValidOffsets();
        }
        ArrayList<ZoneOffset> list = new ArrayList<ZoneOffset>(1);
        list.add((ZoneOffset)info);
        return list;
    }

    @Nullable
    public ZoneOffsetTransition getTransition(LocalDateTime localDateTime) {
        Object info = this.getOffsetInfo(localDateTime);
        return info instanceof ZoneOffsetTransition ? (ZoneOffsetTransition)info : null;
    }

    private Object getOffsetInfo(LocalDateTime dt) {
        int index;
        if (this.savingsInstantTransitions.length == 0) {
            ZoneOffset zoneOffset = this.standardOffsets[0];
            assert (zoneOffset != null);
            return zoneOffset;
        }
        LocalDateTime other = this.computeLatestLocalTransition();
        if (this.lastRules.length > 0 && dt.isAfter(other)) {
            ZoneOffsetTransition[] transArray = this.findTransitionArray(dt.getYear());
            Object info = null;
            assert (transArray != null);
            ZoneOffsetTransition[] zoneOffsetTransitionArray = transArray;
            int n = transArray.length;
            int n2 = 0;
            while (n2 < n) {
                ZoneOffsetTransition trans = zoneOffsetTransitionArray[n2];
                assert (trans != null);
                info = this.findOffsetInfo(dt, trans);
                if (info instanceof ZoneOffsetTransition || info.equals(trans.getOffsetBefore())) {
                    return info;
                }
                ++n2;
            }
            assert (info != null);
            return info;
        }
        if (this.savingsLocalTransitions.length == 0) {
            this.computeLocalTransitions();
        }
        if ((index = Arrays.binarySearch(this.savingsLocalTransitions, dt)) == -1) {
            ZoneOffset zoneOffset = this.wallOffsets[0];
            assert (zoneOffset != null);
            return zoneOffset;
        }
        if (index < 0) {
            index = -index - 2;
        } else if (index < this.savingsLocalTransitions.length - 1 && this.savingsLocalTransitions[index].equals(this.savingsLocalTransitions[index + 1])) {
            ++index;
        }
        ZoneOffset zoneOffset = this.wallOffsets[index / 2 + 1];
        assert (zoneOffset != null);
        if ((index & 1) == 0) {
            LocalDateTime dtBefore = this.savingsLocalTransitions[index];
            assert (dtBefore != null);
            LocalDateTime dtAfter = this.savingsLocalTransitions[index + 1];
            assert (dtAfter != null);
            ZoneOffset offsetBefore = this.wallOffsets[index / 2];
            ZoneOffset offsetAfter = zoneOffset;
            if (offsetAfter.getTotalSeconds() > offsetBefore.getTotalSeconds()) {
                return new ZoneOffsetTransition(dtBefore, offsetBefore, offsetAfter);
            }
            return new ZoneOffsetTransition(dtAfter, offsetBefore, offsetAfter);
        }
        return zoneOffset;
    }

    private void computeLocalTransitions() {
        ArrayList<LocalDateTime> localTransitionList = new ArrayList<LocalDateTime>();
        long[] savingTransitions = this.savingsInstantTransitions;
        ZoneOffset[] savingOffsets = this.wallOffsets;
        int i = 0;
        while (i < savingTransitions.length) {
            ZoneOffset before = savingOffsets[i];
            ZoneOffset after = savingOffsets[i + 1];
            assert (before != null);
            assert (after != null);
            ZoneOffsetTransition trans = new ZoneOffsetTransition(savingTransitions[i], before, after);
            if (trans.isGap()) {
                localTransitionList.add(trans.getDateTimeBefore());
                localTransitionList.add(trans.getDateTimeAfter());
            } else {
                localTransitionList.add(trans.getDateTimeAfter());
                localTransitionList.add(trans.getDateTimeBefore());
            }
            ++i;
        }
        this.savingsLocalTransitions = localTransitionList.toArray(new LocalDateTime[localTransitionList.size()]);
    }

    private LocalDateTime computeLatestLocalTransition() {
        LocalDateTime[] localTransitions = this.savingsLocalTransitions;
        if (localTransitions.length != 0) {
            return localTransitions[localTransitions.length - 1];
        }
        long[] instantTransitions = this.savingsInstantTransitions;
        ZoneOffset[] offsets = this.wallOffsets;
        int lastIndex = instantTransitions.length - 1;
        long epochSecond = instantTransitions[lastIndex];
        ZoneOffset offsetBefore = offsets[lastIndex];
        ZoneOffset offsetAfter = offsets[lastIndex + 1];
        assert (offsetBefore != null);
        assert (offsetAfter != null);
        ZoneOffsetTransition transition = new ZoneOffsetTransition(epochSecond, offsetBefore, offsetAfter);
        return transition.isGap() ? transition.getDateTimeAfter() : transition.getDateTimeBefore();
    }

    private Object findOffsetInfo(LocalDateTime dt, ZoneOffsetTransition trans) {
        LocalDateTime localTransition = trans.getDateTimeBefore();
        if (trans.isGap()) {
            if (dt.isBefore(localTransition)) {
                return trans.getOffsetBefore();
            }
            if (dt.isBefore(trans.getDateTimeAfter())) {
                return trans;
            }
            return trans.getOffsetAfter();
        }
        if (!dt.isBefore(localTransition)) {
            return trans.getOffsetAfter();
        }
        if (dt.isBefore(trans.getDateTimeAfter())) {
            return trans.getOffsetBefore();
        }
        return trans;
    }

    private ZoneOffsetTransition[] findTransitionArray(int year) {
        ZoneOffsetTransitionRule[] ruleArray = this.lastRules;
        ZoneOffsetTransition[] transArray = new ZoneOffsetTransition[ruleArray.length];
        int i = 0;
        while (i < ruleArray.length) {
            transArray[i] = ruleArray[i].createTransition(year);
            ++i;
        }
        return transArray;
    }

    public ZoneOffset getStandardOffset(Instant instant) {
        if (this.savingsInstantTransitions.length == 0) {
            ZoneOffset zoneOffset = this.standardOffsets[0];
            assert (zoneOffset != null);
            return zoneOffset;
        }
        long epochSec = instant.getEpochSecond();
        int index = Arrays.binarySearch(this.standardTransitions, epochSec);
        if (index < 0) {
            index = -index - 2;
        }
        ZoneOffset zoneOffset = this.standardOffsets[index + 1];
        assert (zoneOffset != null);
        return zoneOffset;
    }

    public Duration getDaylightSavings(Instant instant) {
        if (this.savingsInstantTransitions.length == 0) {
            return Duration.ZERO;
        }
        ZoneOffset standardOffset = this.getStandardOffset(instant);
        ZoneOffset actualOffset = this.getOffset(instant);
        return Duration.ofSeconds(actualOffset.getTotalSeconds() - standardOffset.getTotalSeconds());
    }

    public boolean isDaylightSavings(Instant instant) {
        return !this.getStandardOffset(instant).equals(this.getOffset(instant));
    }

    public boolean isValidOffset(LocalDateTime localDateTime, ZoneOffset offset) {
        return this.getValidOffsets(localDateTime).contains(offset);
    }

    @Nullable
    public ZoneOffsetTransition nextTransition(Instant instant) {
        if (this.savingsInstantTransitions.length == 0) {
            return null;
        }
        long epochSec = instant.getEpochSecond();
        if (epochSec >= this.savingsInstantTransitions[this.savingsInstantTransitions.length - 1]) {
            if (this.lastRules.length == 0) {
                return null;
            }
            ZoneOffset offset = this.wallOffsets[this.wallOffsets.length - 1];
            assert (offset != null);
            int year = this.findYear(epochSec, offset);
            ZoneOffsetTransition[] transArray = this.findTransitionArray(year);
            assert (transArray != null);
            ZoneOffsetTransition[] zoneOffsetTransitionArray = transArray;
            int n = transArray.length;
            int n2 = 0;
            while (n2 < n) {
                ZoneOffsetTransition trans = zoneOffsetTransitionArray[n2];
                if (epochSec < trans.toEpochSecond()) {
                    return trans;
                }
                ++n2;
            }
            if (year < 999999999) {
                transArray = this.findTransitionArray(year + 1);
                assert (transArray != null);
                return transArray[0];
            }
            return null;
        }
        int index = Arrays.binarySearch(this.savingsInstantTransitions, epochSec);
        index = index < 0 ? -index - 1 : ++index;
        ZoneOffset offsetBefore = this.wallOffsets[index];
        assert (offsetBefore != null);
        ZoneOffset offsetAfter = this.wallOffsets[index + 1];
        assert (offsetAfter != null);
        return new ZoneOffsetTransition(this.savingsInstantTransitions[index], offsetBefore, offsetAfter);
    }

    @Nullable
    public ZoneOffsetTransition previousTransition(Instant instant) {
        int index;
        if (this.savingsInstantTransitions.length == 0) {
            return null;
        }
        long epochSec = instant.getEpochSecond();
        if (instant.getNano() > 0 && epochSec < Long.MAX_VALUE) {
            ++epochSec;
        }
        long lastHistoric = this.savingsInstantTransitions[this.savingsInstantTransitions.length - 1];
        if (this.lastRules.length > 0 && epochSec > lastHistoric) {
            ZoneOffset lastHistoricOffset = this.wallOffsets[this.wallOffsets.length - 1];
            assert (lastHistoricOffset != null);
            int year = this.findYear(epochSec, lastHistoricOffset);
            ZoneOffsetTransition[] transArray = this.findTransitionArray(year);
            assert (transArray != null);
            int i = transArray.length - 1;
            while (i >= 0) {
                if (epochSec > transArray[i].toEpochSecond()) {
                    return transArray[i];
                }
                --i;
            }
            int lastHistoricYear = this.findYear(lastHistoric, lastHistoricOffset);
            if (--year > lastHistoricYear) {
                transArray = this.findTransitionArray(year);
                assert (transArray != null);
                return transArray[transArray.length - 1];
            }
        }
        if ((index = Arrays.binarySearch(this.savingsInstantTransitions, epochSec)) < 0) {
            index = -index - 1;
        }
        if (index <= 0) {
            return null;
        }
        ZoneOffset offsetBefore = this.wallOffsets[index - 1];
        assert (offsetBefore != null);
        ZoneOffset offsetAfter = this.wallOffsets[index];
        assert (offsetAfter != null);
        return new ZoneOffsetTransition(this.savingsInstantTransitions[index - 1], offsetBefore, offsetAfter);
    }

    private int findYear(long epochSecond, ZoneOffset offset) {
        long localSecond = epochSecond + (long)offset.getTotalSeconds();
        long localEpochDay = localSecond / 86400L;
        if ((localSecond ^ 0x15180L) < 0L && localEpochDay * 12L != localSecond) {
            --localEpochDay;
        }
        return LocalDate.ofEpochDay(localEpochDay).getYear();
    }

    public List<ZoneOffsetTransition> getTransitions() {
        ArrayList<ZoneOffsetTransition> list = new ArrayList<ZoneOffsetTransition>();
        int i = 0;
        while (i < this.savingsInstantTransitions.length) {
            ZoneOffset offsetBefore = this.wallOffsets[i];
            assert (offsetBefore != null);
            ZoneOffset offsetAfter = this.wallOffsets[i + 1];
            assert (offsetAfter != null);
            list.add(new ZoneOffsetTransition(this.savingsInstantTransitions[i], offsetBefore, offsetAfter));
            ++i;
        }
        return list;
    }

    public List<ZoneOffsetTransitionRule> getTransitionRules() {
        ArrayList<ZoneOffsetTransitionRule> list = new ArrayList<ZoneOffsetTransitionRule>(this.lastRules.length);
        ZoneOffsetTransitionRule[] zoneOffsetTransitionRuleArray = this.lastRules;
        int n = this.lastRules.length;
        int n2 = 0;
        while (n2 < n) {
            ZoneOffsetTransitionRule transitionRule = zoneOffsetTransitionRuleArray[n2];
            assert (transitionRule != null);
            list.add(transitionRule);
            ++n2;
        }
        return list;
    }

    public boolean equals(@Nullable Object otherRules) {
        if (this == otherRules) {
            return true;
        }
        if (otherRules instanceof ZoneRules) {
            ZoneRules other = (ZoneRules)otherRules;
            return Arrays.equals(this.standardTransitions, other.standardTransitions) && Arrays.equals(this.standardOffsets, other.standardOffsets) && Arrays.equals(this.savingsInstantTransitions, other.savingsInstantTransitions) && Arrays.equals(this.wallOffsets, other.wallOffsets) && Arrays.equals(this.lastRules, other.lastRules);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.standardTransitions) ^ Arrays.hashCode(this.standardOffsets) ^ Arrays.hashCode(this.savingsInstantTransitions) ^ Arrays.hashCode(this.wallOffsets) ^ Arrays.hashCode(this.lastRules);
    }
}

