/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import ej.annotation.Nullable;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Chronology;
import java.time.chrono.Era;
import java.time.chrono.IsoChronology;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.ValueRange;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractChronology
implements Chronology {
    public static Chronology of(String id) {
        IsoChronology isoChronology = IsoChronology.INSTANCE;
        String calendarType = isoChronology.getCalendarType();
        assert (calendarType != null);
        if (isoChronology.getId().equals(id) || calendarType.equals(id)) {
            return isoChronology;
        }
        throw new DateTimeException("Unknown chronology: " + id);
    }

    public static Set<Chronology> getAvailableChronologies() {
        HashSet<Chronology> chronos = new HashSet<Chronology>(1);
        chronos.add(IsoChronology.INSTANCE);
        return chronos;
    }

    public static Chronology from(TemporalAccessor temporal) {
        Chronology obj = temporal.query(TemporalQueries.chronology());
        return obj != null ? obj : IsoChronology.INSTANCE;
    }

    protected AbstractChronology() {
    }

    @Override
    @Nullable
    public ChronoLocalDate resolveDate(Map<TemporalField, Long> fieldValues, ResolverStyle resolverStyle) {
        if (fieldValues.containsKey(ChronoField.EPOCH_DAY)) {
            Long epochDay = fieldValues.remove(ChronoField.EPOCH_DAY);
            assert (epochDay != null);
            return this.dateEpochDay(epochDay);
        }
        this.resolveProlepticMonth(fieldValues, resolverStyle);
        ChronoLocalDate resolved = this.resolveYearOfEra(fieldValues, resolverStyle);
        if (resolved != null) {
            return resolved;
        }
        if (fieldValues.containsKey(ChronoField.YEAR)) {
            if (fieldValues.containsKey(ChronoField.MONTH_OF_YEAR)) {
                if (fieldValues.containsKey(ChronoField.DAY_OF_MONTH)) {
                    return this.resolveYMD(fieldValues, resolverStyle);
                }
                if (fieldValues.containsKey(ChronoField.ALIGNED_WEEK_OF_MONTH)) {
                    if (fieldValues.containsKey(ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH)) {
                        return this.resolveYMAA(fieldValues, resolverStyle);
                    }
                    if (fieldValues.containsKey(ChronoField.DAY_OF_WEEK)) {
                        return this.resolveYMAD(fieldValues, resolverStyle);
                    }
                }
            }
            if (fieldValues.containsKey(ChronoField.DAY_OF_YEAR)) {
                return this.resolveYD(fieldValues, resolverStyle);
            }
            if (fieldValues.containsKey(ChronoField.ALIGNED_WEEK_OF_YEAR)) {
                if (fieldValues.containsKey(ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR)) {
                    return this.resolveYAA(fieldValues, resolverStyle);
                }
                if (fieldValues.containsKey(ChronoField.DAY_OF_WEEK)) {
                    return this.resolveYAD(fieldValues, resolverStyle);
                }
            }
        }
        return null;
    }

    void resolveProlepticMonth(Map<TemporalField, Long> fieldValues, ResolverStyle resolverStyle) {
        Long pMonth = fieldValues.remove(ChronoField.PROLEPTIC_MONTH);
        if (pMonth != null) {
            if (resolverStyle != ResolverStyle.LENIENT) {
                ChronoField.PROLEPTIC_MONTH.checkValidValue(pMonth);
            }
            ChronoLocalDate chronoDate = this.dateNow().with(ChronoField.DAY_OF_MONTH, 1L).with(ChronoField.PROLEPTIC_MONTH, pMonth);
            this.addFieldValue(fieldValues, ChronoField.MONTH_OF_YEAR, chronoDate.get(ChronoField.MONTH_OF_YEAR));
            this.addFieldValue(fieldValues, ChronoField.YEAR, chronoDate.get(ChronoField.YEAR));
        }
    }

    @Nullable
    ChronoLocalDate resolveYearOfEra(Map<TemporalField, Long> fieldValues, ResolverStyle resolverStyle) {
        Long yoeLong = fieldValues.remove(ChronoField.YEAR_OF_ERA);
        if (yoeLong != null) {
            Long eraLong = fieldValues.remove(ChronoField.ERA);
            int yoe = resolverStyle != ResolverStyle.LENIENT ? this.range(ChronoField.YEAR_OF_ERA).checkValidIntValue(yoeLong, ChronoField.YEAR_OF_ERA) : (int)yoeLong.longValue();
            if (eraLong != null) {
                Era eraObj = this.eraOf(this.range(ChronoField.ERA).checkValidIntValue(eraLong, ChronoField.ERA));
                this.addFieldValue(fieldValues, ChronoField.YEAR, this.prolepticYear(eraObj, yoe));
            } else if (fieldValues.containsKey(ChronoField.YEAR)) {
                Long yearLong = fieldValues.get(ChronoField.YEAR);
                assert (yearLong != null);
                int year = this.range(ChronoField.YEAR).checkValidIntValue(yearLong, ChronoField.YEAR);
                ChronoLocalDate chronoDate = this.dateYearDay(year, 1);
                this.addFieldValue(fieldValues, ChronoField.YEAR, this.prolepticYear(chronoDate.getEra(), yoe));
            } else if (resolverStyle == ResolverStyle.STRICT) {
                fieldValues.put(ChronoField.YEAR_OF_ERA, yoeLong);
            } else {
                List<Era> eras = this.eras();
                if (eras.isEmpty()) {
                    this.addFieldValue(fieldValues, ChronoField.YEAR, yoe);
                } else {
                    Era eraObj = eras.get(eras.size() - 1);
                    this.addFieldValue(fieldValues, ChronoField.YEAR, this.prolepticYear(eraObj, yoe));
                }
            }
        } else if (fieldValues.containsKey(ChronoField.ERA)) {
            Long era = fieldValues.get(ChronoField.ERA);
            assert (era != null);
            this.range(ChronoField.ERA).checkValidValue(era, ChronoField.ERA);
        }
        return null;
    }

    ChronoLocalDate resolveYMD(Map<TemporalField, Long> fieldValues, ResolverStyle resolverStyle) {
        Long year = fieldValues.remove(ChronoField.YEAR);
        assert (year != null);
        int y = this.range(ChronoField.YEAR).checkValidIntValue(year, ChronoField.YEAR);
        Long monthOfYear = fieldValues.remove(ChronoField.MONTH_OF_YEAR);
        assert (monthOfYear != null);
        Long dayOfMonth = fieldValues.remove(ChronoField.DAY_OF_MONTH);
        assert (dayOfMonth != null);
        if (resolverStyle == ResolverStyle.LENIENT) {
            long months = monthOfYear - 1L;
            long days = dayOfMonth - 1L;
            return this.date(y, 1, 1).plus(months, ChronoUnit.MONTHS).plus(days, ChronoUnit.DAYS);
        }
        int moy = this.range(ChronoField.MONTH_OF_YEAR).checkValidIntValue(monthOfYear, ChronoField.MONTH_OF_YEAR);
        ValueRange domRange = this.range(ChronoField.DAY_OF_MONTH);
        int dom = domRange.checkValidIntValue(dayOfMonth, ChronoField.DAY_OF_MONTH);
        if (resolverStyle == ResolverStyle.SMART) {
            try {
                return this.date(y, moy, dom);
            }
            catch (DateTimeException dateTimeException) {
                return this.date(y, moy, 1).with(TemporalAdjusters.lastDayOfMonth());
            }
        }
        return this.date(y, moy, dom);
    }

    ChronoLocalDate resolveYD(Map<TemporalField, Long> fieldValues, ResolverStyle resolverStyle) {
        Long year = fieldValues.remove(ChronoField.YEAR);
        assert (year != null);
        int y = this.range(ChronoField.YEAR).checkValidIntValue(year, ChronoField.YEAR);
        Long dayOfYear = fieldValues.remove(ChronoField.DAY_OF_YEAR);
        assert (dayOfYear != null);
        if (resolverStyle == ResolverStyle.LENIENT) {
            long days = dayOfYear - 1L;
            return this.dateYearDay(y, 1).plus(days, ChronoUnit.DAYS);
        }
        int doy = this.range(ChronoField.DAY_OF_YEAR).checkValidIntValue(dayOfYear, ChronoField.DAY_OF_YEAR);
        return this.dateYearDay(y, doy);
    }

    ChronoLocalDate resolveYMAA(Map<TemporalField, Long> fieldValues, ResolverStyle resolverStyle) {
        Long year = fieldValues.remove(ChronoField.YEAR);
        assert (year != null);
        int y = this.range(ChronoField.YEAR).checkValidIntValue(year, ChronoField.YEAR);
        Long monthOfYear = fieldValues.remove(ChronoField.MONTH_OF_YEAR);
        assert (monthOfYear != null);
        Long alignedWeekOfMonth = fieldValues.remove(ChronoField.ALIGNED_WEEK_OF_MONTH);
        assert (alignedWeekOfMonth != null);
        Long alignedDoWinMonth = fieldValues.remove(ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH);
        assert (alignedDoWinMonth != null);
        if (resolverStyle == ResolverStyle.LENIENT) {
            long months = monthOfYear - 1L;
            long weeks = alignedWeekOfMonth - 1L;
            long days = alignedDoWinMonth - 1L;
            return this.date(y, 1, 1).plus(months, ChronoUnit.MONTHS).plus(weeks, ChronoUnit.WEEKS).plus(days, ChronoUnit.DAYS);
        }
        int moy = this.range(ChronoField.MONTH_OF_YEAR).checkValidIntValue(monthOfYear, ChronoField.MONTH_OF_YEAR);
        int aw = this.range(ChronoField.ALIGNED_WEEK_OF_MONTH).checkValidIntValue(alignedWeekOfMonth, ChronoField.ALIGNED_WEEK_OF_MONTH);
        int ad = this.range(ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH).checkValidIntValue(alignedDoWinMonth, ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH);
        ChronoLocalDate date = this.date(y, moy, 1).plus((long)(aw - 1) * 7L + (long)(ad - 1), ChronoUnit.DAYS);
        if (resolverStyle == ResolverStyle.STRICT && date.get(ChronoField.MONTH_OF_YEAR) != moy) {
            throw new DateTimeException("Strict mode rejected resolved date as it is in a different month");
        }
        return date;
    }

    ChronoLocalDate resolveYMAD(Map<TemporalField, Long> fieldValues, ResolverStyle resolverStyle) {
        Long year = fieldValues.remove(ChronoField.YEAR);
        assert (year != null);
        int y = this.range(ChronoField.YEAR).checkValidIntValue(year, ChronoField.YEAR);
        Long monthOfYear = fieldValues.remove(ChronoField.MONTH_OF_YEAR);
        assert (monthOfYear != null);
        Long alignedWeekOfMonth = fieldValues.remove(ChronoField.ALIGNED_WEEK_OF_MONTH);
        assert (alignedWeekOfMonth != null);
        Long dayOfWeek = fieldValues.remove(ChronoField.DAY_OF_WEEK);
        assert (dayOfWeek != null);
        if (resolverStyle == ResolverStyle.LENIENT) {
            long months = monthOfYear - 1L;
            long weeks = alignedWeekOfMonth - 1L;
            long dow = dayOfWeek - 1L;
            return this.resolveAligned(this.date(y, 1, 1), months, weeks, dow);
        }
        int moy = this.range(ChronoField.MONTH_OF_YEAR).checkValidIntValue(monthOfYear, ChronoField.MONTH_OF_YEAR);
        int aw = this.range(ChronoField.ALIGNED_WEEK_OF_MONTH).checkValidIntValue(alignedWeekOfMonth, ChronoField.ALIGNED_WEEK_OF_MONTH);
        int dow = this.range(ChronoField.DAY_OF_WEEK).checkValidIntValue(dayOfWeek, ChronoField.DAY_OF_WEEK);
        ChronoLocalDate date = this.date(y, moy, 1).plus((long)(aw - 1) * 7L, ChronoUnit.DAYS).with(TemporalAdjusters.nextOrSame(DayOfWeek.of(dow)));
        if (resolverStyle == ResolverStyle.STRICT && date.get(ChronoField.MONTH_OF_YEAR) != moy) {
            throw new DateTimeException("Strict mode rejected resolved date as it is in a different month");
        }
        return date;
    }

    ChronoLocalDate resolveYAA(Map<TemporalField, Long> fieldValues, ResolverStyle resolverStyle) {
        Long year = fieldValues.remove(ChronoField.YEAR);
        assert (year != null);
        int y = this.range(ChronoField.YEAR).checkValidIntValue(year, ChronoField.YEAR);
        Long alignedWeekOfYear = fieldValues.remove(ChronoField.ALIGNED_WEEK_OF_YEAR);
        assert (alignedWeekOfYear != null);
        Long alignedDoWinYear = fieldValues.remove(ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR);
        assert (alignedDoWinYear != null);
        if (resolverStyle == ResolverStyle.LENIENT) {
            long weeks = alignedWeekOfYear - 1L;
            long days = alignedDoWinYear - 1L;
            return this.dateYearDay(y, 1).plus(weeks, ChronoUnit.WEEKS).plus(days, ChronoUnit.DAYS);
        }
        int aw = this.range(ChronoField.ALIGNED_WEEK_OF_YEAR).checkValidIntValue(alignedWeekOfYear, ChronoField.ALIGNED_WEEK_OF_YEAR);
        int ad = this.range(ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR).checkValidIntValue(alignedDoWinYear, ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR);
        ChronoLocalDate date = this.dateYearDay(y, 1).plus((long)(aw - 1) * 7L + (long)(ad - 1), ChronoUnit.DAYS);
        if (resolverStyle == ResolverStyle.STRICT && date.get(ChronoField.YEAR) != y) {
            throw new DateTimeException("Strict mode rejected resolved date as it is in a different year");
        }
        return date;
    }

    ChronoLocalDate resolveYAD(Map<TemporalField, Long> fieldValues, ResolverStyle resolverStyle) {
        Long year = fieldValues.remove(ChronoField.YEAR);
        assert (year != null);
        int y = this.range(ChronoField.YEAR).checkValidIntValue(year, ChronoField.YEAR);
        Long alignedWeekOfYear = fieldValues.remove(ChronoField.ALIGNED_WEEK_OF_YEAR);
        assert (alignedWeekOfYear != null);
        Long dayOfWeek = fieldValues.remove(ChronoField.DAY_OF_WEEK);
        assert (dayOfWeek != null);
        if (resolverStyle == ResolverStyle.LENIENT) {
            long weeks = alignedWeekOfYear - 1L;
            long dow = dayOfWeek - 1L;
            return this.resolveAligned(this.dateYearDay(y, 1), 0L, weeks, dow);
        }
        int aw = this.range(ChronoField.ALIGNED_WEEK_OF_YEAR).checkValidIntValue(alignedWeekOfYear, ChronoField.ALIGNED_WEEK_OF_YEAR);
        int dow = this.range(ChronoField.DAY_OF_WEEK).checkValidIntValue(dayOfWeek, ChronoField.DAY_OF_WEEK);
        ChronoLocalDate date = this.dateYearDay(y, 1).plus((long)(aw - 1) * 7L, ChronoUnit.DAYS).with(TemporalAdjusters.nextOrSame(DayOfWeek.of(dow)));
        if (resolverStyle == ResolverStyle.STRICT && date.get(ChronoField.YEAR) != y) {
            throw new DateTimeException("Strict mode rejected resolved date as it is in a different year");
        }
        return date;
    }

    ChronoLocalDate resolveAligned(ChronoLocalDate base, long months, long weeks, long dow) {
        ChronoLocalDate date = base.plus(months, ChronoUnit.MONTHS).plus(weeks, ChronoUnit.WEEKS);
        if (dow > 7L) {
            date = date.plus((dow - 1L) / 7L, ChronoUnit.WEEKS);
            dow = (dow - 1L) % 7L + 1L;
        } else if (dow < 1L) {
            date = date.plus((dow - 7L) / 7L, ChronoUnit.WEEKS);
            dow = (dow + 6L) % 7L + 1L;
        }
        return date.with(TemporalAdjusters.nextOrSame(DayOfWeek.of((int)dow)));
    }

    void addFieldValue(Map<TemporalField, Long> fieldValues, ChronoField field, long value) {
        Long old = fieldValues.get(field);
        if (old != null && old != value) {
            throw new DateTimeException("Conflict found: " + field + " " + old + " differs from " + field + " " + value);
        }
        fieldValues.put(field, value);
    }

    @Override
    public int compareTo(Chronology other) {
        return this.getId().compareTo(other.getId());
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AbstractChronology) {
            return this.compareTo((AbstractChronology)obj) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() ^ this.getId().hashCode();
    }

    @Override
    public String toString() {
        return this.getId();
    }
}

