/*
 * Decompiled with CFR 0.152.
 */
package com.microej.kf.util.control.net;

import com.microej.kf.util.control.net.Bandwidth;
import com.microej.kf.util.control.net.BandwidthLimitException;
import java.util.Date;

public class BandwidthChecker {
    private static final long DAY_TO_MS = 86400000L;
    private static final long HOUR_TO_MS = 3600000L;
    private static final long SECOND_TO_MS = 1000L;
    private final long maxByteCount;
    private final Bandwidth.Period period;
    private long byteCount = 0L;
    private long startTime = System.currentTimeMillis();
    private long timeIncrement;

    public BandwidthChecker(Bandwidth.Period period, long maxBytes) {
        this.maxByteCount = maxBytes;
        this.period = period;
        switch (period) {
            case SECOND: {
                this.timeIncrement = 1000L;
                break;
            }
            case HOUR: {
                this.timeIncrement = 3600000L;
                break;
            }
            case DAY: {
                this.timeIncrement = 86400000L;
                break;
            }
        }
    }

    public long getMaxByteCount() {
        return this.maxByteCount;
    }

    public Bandwidth.Period getPeriod() {
        return this.period;
    }

    public synchronized long check(long nbBytes, boolean write) throws BandwidthLimitException {
        long available;
        if (nbBytes <= 0L || this.maxByteCount < 0L) {
            return nbBytes;
        }
        long elapsedTime = System.currentTimeMillis() - this.startTime;
        if (elapsedTime > this.timeIncrement) {
            this.startTime += this.timeIncrement;
            this.byteCount = 0L;
        }
        if ((available = this.maxByteCount - this.byteCount) <= 0L) {
            throw new BandwidthLimitException(new Date(this.startTime + this.timeIncrement));
        }
        if (write) {
            if (nbBytes > available) {
                throw new BandwidthLimitException(new Date(this.startTime + this.timeIncrement));
            }
            return nbBytes;
        }
        if (available > nbBytes) {
            available = nbBytes;
        }
        return available;
    }

    public synchronized void update(long nbBytes) {
        this.byteCount += nbBytes;
    }

    public String toString() {
        return "[Period (ms): " + this.timeIncrement + ", Data-limit (bytes): " + this.maxByteCount + "]";
    }
}

