/*
 * Decompiled with CFR 0.152.
 */
package ej.widget.render;

import ej.microui.display.Font;
import java.util.ArrayList;

public class TextHelper {
    private static final char SPACE = ' ';
    private static final char NEW_LINE = '\n';
    private static final char CARRIAGE_RETURN = '\r';

    private TextHelper() {
    }

    public static String[] wrap(String string, Font font, int width) {
        int index;
        if (string.isEmpty()) {
            return new String[0];
        }
        ArrayList<String> lines = new ArrayList<String>(1);
        int lastIndex = 0;
        int lastSplitIndex = 0;
        int currentWidth = 0;
        int spaceWidth = font.charWidth(' ');
        int nextSpace = string.indexOf(32);
        boolean moreSpaces = nextSpace != -1;
        int nextLine = string.indexOf(10);
        boolean moreLines = nextLine != -1;
        boolean stop = false;
        while (true) {
            boolean isSpace;
            if (moreLines && (!moreSpaces || nextSpace > nextLine)) {
                isSpace = false;
                index = nextLine;
                moreLines = (nextLine = string.indexOf(10, index + 1)) != -1;
            } else if (moreSpaces) {
                isSpace = true;
                index = nextSpace;
                moreSpaces = (nextSpace = string.indexOf(32, index + 1)) != -1;
            } else {
                isSpace = false;
                index = string.length();
                stop = true;
            }
            int wordWidth = font.substringWidth(string, lastIndex, index - lastIndex);
            if (wordWidth + currentWidth > width) {
                try {
                    lines.add(string.substring(lastSplitIndex, lastIndex - 1));
                    lastSplitIndex = lastIndex;
                    currentWidth = 0;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            }
            lastIndex = index + 1;
            if (isSpace) {
                currentWidth += wordWidth + spaceWidth;
                continue;
            }
            if (stop) break;
            if (string.charAt(index - 1) == '\r') {
                lines.add(string.substring(lastSplitIndex, index - 1));
            } else {
                lines.add(string.substring(lastSplitIndex, index));
            }
            lastSplitIndex = lastIndex;
            currentWidth = 0;
        }
        lines.add(string.substring(lastSplitIndex, index));
        return lines.toArray(new String[lines.size()]);
    }

    public static String[] getLines(String string) {
        return TextHelper.splitString(string, '\n');
    }

    public static String[] getWords(String string) {
        return TextHelper.splitString(string, ' ');
    }

    private static String[] splitString(String string, char separator) {
        if (string.isEmpty()) {
            return new String[0];
        }
        ArrayList<String> elements = new ArrayList<String>(1);
        int newSeparatorIndex = 0;
        while (true) {
            int separatorIndex;
            if ((separatorIndex = string.indexOf(separator, newSeparatorIndex)) == -1) break;
            elements.add(string.substring(newSeparatorIndex, separatorIndex));
            newSeparatorIndex = separatorIndex + 1;
        }
        elements.add(string.substring(newSeparatorIndex));
        return elements.toArray(new String[elements.size()]);
    }
}

