/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt.stylesheet.cascading;

import ej.basictool.ArrayTools;
import ej.mwt.Container;
import ej.mwt.Widget;
import ej.mwt.style.EditableStyle;
import ej.mwt.style.Style;
import ej.mwt.stylesheet.Stylesheet;
import ej.mwt.stylesheet.cascading.CascadingStyle;
import ej.mwt.stylesheet.selector.Selector;

public class CascadingStylesheet
implements Stylesheet {
    private EditableStyle defaultStyle = new EditableStyle();
    private Object[] selectorStyles = new Object[0];

    @Override
    public Style getStyle(Widget widget) {
        CascadingStyle resultingStyle = new CascadingStyle(this.defaultStyle);
        this.mergeSelectors(widget, resultingStyle);
        Container parentWidget = widget.getParent();
        if (parentWidget != null) {
            Style parentStyle = parentWidget.getStyle();
            resultingStyle.inheritMerge(parentStyle);
        }
        resultingStyle.updateHashCode();
        return resultingStyle;
    }

    private void mergeSelectors(Widget widget, CascadingStyle resultingStyle) {
        Object[] selectorStyles = this.selectorStyles;
        int i = 0;
        while (i < selectorStyles.length) {
            if (((Selector)selectorStyles[i]).appliesToWidget(widget)) {
                CascadingStyle style = (CascadingStyle)selectorStyles[i + 1];
                assert (style != null);
                resultingStyle.merge(style);
            }
            i += 2;
        }
    }

    public EditableStyle getDefaultStyle() {
        return this.defaultStyle;
    }

    public void resetDefaultStyle() {
        this.defaultStyle = new EditableStyle();
    }

    public EditableStyle getSelectorStyle(Selector selector) {
        Object[] selectorStyles = this.selectorStyles;
        int selectorIndex = CascadingStylesheet.getSelectorIndex(selector, selectorStyles);
        if (selectorIndex != -1) {
            CascadingStyle style = (CascadingStyle)selectorStyles[selectorIndex + 1];
            assert (style != null);
            return style;
        }
        CascadingStyle style = new CascadingStyle();
        int index = CascadingStylesheet.getIndex(selector, selectorStyles);
        selectorStyles = ArrayTools.grow((Object[])selectorStyles, (int)index, (int)2);
        selectorStyles[index] = selector;
        selectorStyles[index + 1] = style;
        this.selectorStyles = selectorStyles;
        return style;
    }

    public void resetSelectorStyle(Selector selector) {
        Object[] selectorStyles = this.selectorStyles;
        int selectorIndex = CascadingStylesheet.getSelectorIndex(selector, selectorStyles);
        if (selectorIndex != -1) {
            this.selectorStyles = ArrayTools.shrink((Object[])selectorStyles, (int)selectorIndex, (int)2);
        }
    }

    public void reset() {
        this.defaultStyle = new EditableStyle();
        this.selectorStyles = new Object[0];
    }

    private static int getIndex(Selector selector, Object[] selectorStyles) {
        int specificity = selector.getSpecificity();
        int minIndex = 0;
        int maxIndex = selectorStyles.length / 2;
        while (maxIndex - minIndex > 1) {
            int currentIndex = (maxIndex - minIndex) / 2 + minIndex;
            if (CascadingStylesheet.isMoreSpecific(selectorStyles, currentIndex * 2, specificity)) {
                minIndex = currentIndex;
                continue;
            }
            maxIndex = currentIndex;
        }
        if (maxIndex > minIndex) {
            if (CascadingStylesheet.isMoreSpecific(selectorStyles, minIndex * 2, specificity)) {
                return maxIndex * 2;
            }
            return minIndex * 2;
        }
        return minIndex * 2;
    }

    private static boolean isMoreSpecific(Object[] selectorStyles, int index, int specificity) {
        int specificityCandidate = ((Selector)selectorStyles[index]).getSpecificity();
        return specificityCandidate > specificity;
    }

    private static int getSelectorIndex(Selector selector, Object[] selectorStyles) {
        int i = 0;
        while (i < selectorStyles.length) {
            if (selector.equals(selectorStyles[i])) {
                return i;
            }
            i += 2;
        }
        return -1;
    }
}

