/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.http.body;

import ej.hoka.http.HTTPRequest;
import ej.hoka.http.body.BodyParser;
import ej.hoka.http.body.HTTPPart;
import java.io.IOException;
import java.io.InputStream;

public class MultiPartBodyParser
implements BodyParser {
    private static final int SIZE = 512;
    public static final String BOUNDARY = "boundary=";
    private MultiPartBuffer buffer;

    @Override
    public void parseBody(HTTPRequest httpRequest) throws IOException {
        String contentType = httpRequest.getHeaderField("content-type");
        if (contentType != null && contentType.startsWith("multipart/form-data")) {
            String boundary = contentType.substring(contentType.indexOf(59) + 1);
            this.buffer = new MultiPartBuffer();
            this.buffer.boundary = ("\r\n--" + boundary.substring(boundary.indexOf(BOUNDARY) + BOUNDARY.length())).getBytes();
            this.buffer.stream = httpRequest.getStream();
            this.buffer.buffer = new byte[512];
            ((MultiPartBuffer)this.buffer).buffer[0] = 13;
            ((MultiPartBuffer)this.buffer).buffer[1] = 10;
            this.buffer.lengthAvailable = 2;
        }
    }

    public HTTPPart nextPart() throws IOException {
        if (this.buffer != null && this.buffer.hasData()) {
            HTTPPart httpPart = new HTTPPart(this.buffer);
            if (httpPart.parseHeaders().size() == 0 && !this.buffer.hasData()) {
                httpPart.close();
                httpPart = null;
            }
            return httpPart;
        }
        return null;
    }

    static class MultiPartBuffer {
        private InputStream stream;
        private byte[] boundary;
        private byte[] buffer;
        private int offset;
        private int lengthAvailable;

        MultiPartBuffer() {
        }

        public boolean hasData() throws IOException {
            return this.buffer != null && this.boundary != null && (this.lengthAvailable > 0 || this.stream != null && this.stream.available() > 0);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            this.buffer(len);
            int read = -1;
            int toRead = len;
            int boundaryIndex = this.getBoundaryIndex(toRead);
            toRead = boundaryIndex != -1 ? boundaryIndex : Math.min(toRead, this.lengthAvailable - this.boundary.length);
            if (toRead > 0) {
                System.arraycopy(this.buffer, this.offset, b, off, toRead);
                this.offset += toRead;
                this.lengthAvailable -= toRead;
                read = toRead;
            }
            return read;
        }

        public int read() throws IOException {
            this.buffer(1);
            int read = this.buffer[this.offset] & 0xFF;
            ++this.offset;
            --this.lengthAvailable;
            return read;
        }

        public void skipToBoundary() throws IOException {
            this.buffer(1);
            int boundaryIndex = this.getBoundaryIndex(this.lengthAvailable);
            int boundaryLength = this.boundary.length;
            while (boundaryIndex == -1 && (this.lengthAvailable > 0 || this.stream != null && this.stream.available() > 0)) {
                System.arraycopy(this.buffer, this.offset + this.lengthAvailable - boundaryLength, this.buffer, 0, boundaryLength);
                this.lengthAvailable = boundaryLength;
                this.offset = 0;
                boundaryIndex = this.getBoundaryIndex(this.lengthAvailable);
            }
            if (boundaryIndex != -1) {
                int offset = boundaryIndex + boundaryLength + 2;
                this.offset += offset;
                this.lengthAvailable -= offset;
            }
        }

        public int getBoundaryIndex(int length) throws IOException {
            this.buffer(1);
            int boundary = -1;
            int boundaryLength = this.boundary.length;
            int boundaryStart = 0;
            while (boundaryStart < Math.min(length, this.lengthAvailable - boundaryLength - 1)) {
                int i = 0;
                while (i < boundaryLength) {
                    if (this.buffer[this.offset + i + boundaryStart] != this.boundary[i]) break;
                    ++i;
                }
                if (i == boundaryLength) {
                    boundary = boundaryStart;
                    break;
                }
                ++boundaryStart;
            }
            return boundary;
        }

        private void buffer(int length) throws IOException {
            int lengthAvailable = this.lengthAvailable;
            if (this.stream != null && lengthAvailable - this.boundary.length - 1 < length) {
                int read;
                int offset = this.offset;
                int bufferLength = this.buffer.length;
                if (offset != 0) {
                    System.arraycopy(this.buffer, offset, this.buffer, 0, lengthAvailable);
                }
                if ((read = this.stream.read(this.buffer, lengthAvailable, bufferLength - lengthAvailable)) > 0) {
                    this.lengthAvailable += read;
                }
                this.offset = 0;
            }
        }
    }
}

