/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.http;

import ej.hoka.http.HTTPServer;
import ej.hoka.http.IHTTPEncodingHandler;
import ej.hoka.http.IHTTPTransferCodingHandler;
import ej.hoka.http.UnsupportedHTTPEncodingException;
import ej.hoka.http.body.BodyParser;
import ej.hoka.http.body.BodyParserFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class HTTPRequest {
    public static final int POST = 1;
    public static final int GET = 2;
    public static final int PUT = 3;
    public static final int DELETE = 4;
    private static final char SPACE_CHAR = ' ';
    private static final char PERCENTAGE_CHAR = '%';
    private static final char COLON_CHAR = ':';
    private static final char NEWLINE_CHAR = '\n';
    private static final char CARRIAGE_RETURN_CHAR = '\r';
    private static final char TABULATION_CHAR = '\t';
    private static final char AMPERSAND_CHAR = '&';
    private static final char EQUAL_CHAR = '=';
    private static final char PLUS_CHAR = '+';
    private static final char QUESTION_MARK_CHAR = '?';
    private static final String MALFORMED_HTTP_REQUEST = "Malformed HTTP Request";
    private static final int END_OF_FILE = -1;
    private static final int HEXA = 16;
    private final InputStream stream;
    private final HTTPServer server;
    private final HashMap<String, String> parameters;
    private int method;
    private String uri;
    private String version;
    private HashMap<String, String> header;
    private BodyParser bodyParser;

    protected HTTPRequest(HTTPServer server, InputStream inputStream, BodyParserFactory bodyParserFactory) throws IOException, IllegalArgumentException {
        this.server = server;
        this.parameters = new HashMap(10);
        if (!this.parseRequestHeader(inputStream)) {
            throw new IllegalArgumentException(MALFORMED_HTTP_REQUEST);
        }
        String contentType = this.getHeaderField("content-type");
        this.stream = this.getContentEncodingStream(inputStream);
        if ("application/x-www-form-urlencoded".equalsIgnoreCase(contentType) && !this.parseRequestBody(this.stream)) {
            throw new IllegalArgumentException(MALFORMED_HTTP_REQUEST);
        }
        if (bodyParserFactory != null) {
            this.bodyParser = bodyParserFactory.newBodyParser(this);
        }
    }

    protected HTTPRequest(HTTPServer server, InputStream inputStream) throws IOException, IllegalArgumentException {
        this(server, inputStream, null);
    }

    private static int decodePercentage(InputStream is) throws IOException {
        boolean fourByte;
        boolean oneByte;
        int x = HTTPRequest.readEncodedCharacter(is, false);
        boolean bl = oneByte = x >>> 7 == 0;
        if (oneByte) {
            return x;
        }
        boolean twoByte = x >>> 5 == 6;
        boolean threeByte = x >>> 4 == 14;
        boolean bl2 = fourByte = x >>> 3 == 30;
        if (!(twoByte || threeByte || fourByte)) {
            return -1;
        }
        int y = HTTPRequest.readEncodedCharacter(is, true);
        if (y >>> 6 != 2) {
            return -1;
        }
        if (twoByte) {
            x = (x & 0x1F) << 6;
            return (y &= 0x3F) | x;
        }
        int z = HTTPRequest.readEncodedCharacter(is, true);
        if (z >>> 6 != 2) {
            return -1;
        }
        if (threeByte) {
            y = (y & 0x3F) << 6;
            x = (x & 0xF) << 12;
            return (z &= 0x3F) | y | x;
        }
        int u = HTTPRequest.readEncodedCharacter(is, true);
        if (u >>> 6 != 2) {
            return -1;
        }
        if (fourByte) {
            z = (z & 0x3F) << 6;
            y = (y & 0x3F) << 12;
            x = (x & 7) << 18;
            return (u &= 0x3F) | z | y | x;
        }
        return -1;
    }

    private static int handleSurrogatePair(int code, StringBuilder sb) {
        if (code > 65535) {
            int h = ((code -= 65536) >>> 10) + 55296;
            int l = (code & 0x3FF) + 56320;
            sb.append((char)h);
            code = l;
            return code;
        }
        return code;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean parserParameters(Map<String, String> parameters, InputStream is) throws IOException {
        boolean end = false;
        StringBuilder sbKey = new StringBuilder(16);
        StringBuilder sbValue = new StringBuilder(4);
        StringBuilder curBuffer = sbKey;
        block8: while (!end) {
            int i = is.read();
            switch (i) {
                case 37: {
                    i = HTTPRequest.decodePercentage(is);
                    if (i == -1) {
                        return false;
                    }
                    i = HTTPRequest.handleSurrogatePair(i, curBuffer);
                    break;
                }
                case 43: {
                    i = 32;
                    break;
                }
                case -1: {
                    if (sbKey.length() <= 0) return true;
                    parameters.put(sbKey.toString(), sbValue.toString());
                    return true;
                }
                case 61: {
                    curBuffer = sbValue;
                    continue block8;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    end = true;
                }
                case 38: {
                    parameters.put(sbKey.toString(), sbValue.toString());
                    sbValue.delete(0, sbValue.length());
                    sbKey.delete(0, sbKey.length());
                    curBuffer = sbKey;
                    continue block8;
                }
            }
            curBuffer.append((char)i);
        }
        return true;
    }

    private static int readEncodedCharacter(InputStream is, boolean readPercentageCharacter) throws IOException {
        int x;
        int i;
        char percent;
        if (readPercentageCharacter && (percent = (char)(i = is.read())) != '%') {
            return -1;
        }
        i = is.read();
        char c1 = (char)i;
        if (i == -1) {
            return -1;
        }
        i = is.read();
        char c2 = (char)i;
        if (i == -1) {
            return -1;
        }
        try {
            x = Character.digit(c1, 16) * 16 + Character.digit(c2, 16);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        return x;
    }

    protected void finish() {
    }

    private InputStream getContentEncodingStream(InputStream in) throws IOException {
        HTTPServer server = this.server;
        String transferEncoding = this.getHeaderField("transfer-encoding");
        IHTTPTransferCodingHandler transferCodingHandler = server.getTransferCodingHandler(transferEncoding);
        if (transferCodingHandler == null) {
            throw new UnsupportedHTTPEncodingException("transfer-encoding", transferEncoding);
        }
        in = transferCodingHandler.open(this, in);
        String contentEncoding = this.getHeaderField("content-encoding");
        if (contentEncoding != null) {
            IHTTPEncodingHandler handler = server.getEncodingHandler(contentEncoding);
            if (handler == null) {
                throw new UnsupportedHTTPEncodingException("content-encoding", contentEncoding);
            }
            in = handler.open(in);
        }
        return in;
    }

    public Map<String, String> getHeader() {
        return (Map)this.header.clone();
    }

    public String getHeaderField(String key) {
        if (key == null) {
            return null;
        }
        return this.header.get(key.toLowerCase());
    }

    public int getMethod() {
        return this.method;
    }

    public Map<String, String> getParameters() {
        return (Map)this.parameters.clone();
    }

    public String getURI() {
        return this.uri;
    }

    public String getVersion() {
        return this.version;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseHeaderFields(InputStream input) throws IOException {
        HashMap<String, String> header = new HashMap<String, String>(10);
        StringBuilder sbKey = new StringBuilder(16);
        StringBuilder sbValue = new StringBuilder(16);
        StringBuilder curBuffer = sbKey;
        boolean pendingSpace = false;
        int i = input.read();
        block6: while (true) {
            if (i == -1) {
                return false;
            }
            switch (i) {
                case 37: {
                    if (curBuffer != sbKey) break;
                    return false;
                }
                case 58: {
                    if (curBuffer != sbKey) break;
                    curBuffer = sbValue;
                    i = input.read();
                    continue block6;
                }
                case 9: 
                case 32: {
                    pendingSpace = true;
                    i = input.read();
                    continue block6;
                }
                case 13: {
                    i = input.read();
                    if (i != 10) {
                        return false;
                    }
                    if (sbKey.length() == 0 && sbValue.length() == 0) break block6;
                    i = input.read();
                    if (i == -1) {
                        return false;
                    }
                    if (i == 32 || i == 9) continue block6;
                    if (sbKey.charAt(sbKey.length() - 1) != '*') {
                        header.put(sbKey.toString().toLowerCase(), sbValue.toString());
                    }
                    sbValue.delete(0, sbValue.length());
                    sbKey.delete(0, sbKey.length());
                    curBuffer = sbKey;
                    continue block6;
                }
            }
            if (pendingSpace) {
                pendingSpace = false;
                if (curBuffer.length() > 0) {
                    curBuffer.append(' ');
                }
            }
            curBuffer.append((char)i);
            i = input.read();
        }
        this.header = header;
        return true;
    }

    private boolean parseMethod(InputStream input) throws IOException {
        String inputMethod;
        StringBuilder builder = new StringBuilder();
        int read = input.read();
        while (read != -1 && read != 32) {
            builder.append((char)read);
            read = input.read();
        }
        switch (inputMethod = builder.toString().toUpperCase()) {
            case "GET": {
                this.method = 2;
                return true;
            }
            case "POST": {
                this.method = 1;
                return true;
            }
            case "PUT": {
                this.method = 3;
                return true;
            }
            case "DELETE": {
                this.method = 4;
                return true;
            }
        }
        return false;
    }

    protected boolean parseRequestBody(InputStream stream) throws IOException {
        return HTTPRequest.parserParameters(this.parameters, stream);
    }

    protected boolean parseRequestHeader(InputStream input) throws IOException {
        if (!this.parseMethod(input)) {
            return false;
        }
        if (!this.parseURI(input)) {
            return false;
        }
        return this.parseHeaderFields(input);
    }

    private boolean parseURI(InputStream input) throws IOException {
        StringBuilder sb = new StringBuilder(Math.min(64, input.available()));
        block5: while (true) {
            int i;
            if ((i = input.read()) == -1) {
                return false;
            }
            switch (i) {
                case 63: {
                    if (HTTPRequest.parserParameters(this.parameters, input)) break block5;
                    return false;
                }
                case 32: {
                    break block5;
                }
                case 37: {
                    i = HTTPRequest.decodePercentage(input);
                    if (i == -1) {
                        return false;
                    }
                    i = HTTPRequest.handleSurrogatePair(i, sb);
                }
                default: {
                    sb.append((char)i);
                    continue block5;
                }
            }
            break;
        }
        this.uri = sb.toString();
        byte[] version = new byte[10];
        int readBytes = 0;
        while (readBytes < 10) {
            int r = input.read(version, readBytes, 10 - readBytes);
            if (r == -1) {
                return false;
            }
            readBytes += r;
        }
        String tmp = new String(version);
        this.version = tmp.substring(0, tmp.length() - 2);
        return true;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public BodyParser getBodyParser() {
        return this.bodyParser;
    }

    public void setBodyParser(BodyParser bodyParser) {
        this.bodyParser = bodyParser;
    }

    public void parseBody() throws IOException {
        BodyParser bodyParser = this.bodyParser;
        if (bodyParser != null) {
            bodyParser.parseBody(this);
        }
    }
}

