/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import ej.annotation.Nullable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PushbackInputStream
extends FilterInputStream {
    @Nullable
    protected byte[] buf;
    protected int pos;

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    public PushbackInputStream(InputStream in, int size) {
        super(in);
        if (size <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        this.buf = new byte[size];
        this.pos = size;
    }

    public PushbackInputStream(InputStream in) {
        this(in, 1);
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        byte[] buf = this.buf;
        assert (buf != null);
        if (this.pos < buf.length) {
            return buf[this.pos++] & 0xFF;
        }
        return super.read();
    }

    @Override
    public int read(@Nullable byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        byte[] buf = this.buf;
        assert (buf != null);
        int avail = buf.length - this.pos;
        if (avail > 0) {
            if (len < avail) {
                avail = len;
            }
            System.arraycopy(buf, this.pos, b, off, avail);
            this.pos += avail;
            off += avail;
            len -= avail;
        }
        if (len > 0) {
            if ((len = super.read(b, off, len)) == -1) {
                return avail == 0 ? -1 : avail;
            }
            return avail + len;
        }
        return avail;
    }

    public void unread(int b) throws IOException {
        this.ensureOpen();
        if (this.pos == 0) {
            throw new IOException("Push back buffer is full");
        }
        byte[] buf = this.buf;
        assert (buf != null);
        buf[--this.pos] = (byte)b;
    }

    public void unread(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        if (len > this.pos) {
            throw new IOException("Push back buffer is full");
        }
        this.pos -= len;
        byte[] buf = this.buf;
        assert (buf != null);
        System.arraycopy(b, off, buf, this.pos, len);
    }

    public void unread(byte[] b) throws IOException {
        this.unread(b, 0, b.length);
    }

    @Override
    public int available() throws IOException {
        this.ensureOpen();
        byte[] buf = this.buf;
        assert (buf != null);
        int n = buf.length - this.pos;
        int avail = super.available();
        return n > Integer.MAX_VALUE - avail ? Integer.MAX_VALUE : n + avail;
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureOpen();
        if (n <= 0L) {
            return 0L;
        }
        byte[] buf = this.buf;
        assert (buf != null);
        long pskip = buf.length - this.pos;
        if (pskip > 0L) {
            if (n < pskip) {
                pskip = n;
            }
            this.pos = (int)((long)this.pos + pskip);
            n -= pskip;
        }
        if (n > 0L) {
            pskip += super.skip(n);
        }
        return pskip;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public synchronized void close() throws IOException {
        InputStream in = this.in;
        if (in == null) {
            return;
        }
        in.close();
        this.in = null;
        this.buf = null;
    }
}

