/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.auth.session;

import ej.hoka.auth.SessionAuthenticator;
import ej.hoka.http.HTTPRequest;
import ej.hoka.http.HTTPResponse;
import ej.hoka.rest.RestEndpoint;
import java.util.Map;

public abstract class LoginEndpoint
extends RestEndpoint {
    private final SessionAuthenticator authenticator;

    public LoginEndpoint(String uri, SessionAuthenticator authenticator) {
        super(uri);
        this.authenticator = authenticator;
    }

    @Override
    public HTTPResponse get(HTTPRequest request, Map<String, String> attributes) {
        return this.process(request, attributes);
    }

    @Override
    public HTTPResponse put(HTTPRequest request, Map<String, String> attributes) {
        return this.process(request, attributes);
    }

    protected abstract String login(HTTPRequest var1, Map<String, String> var2);

    protected abstract HTTPResponse successfulLoginResponse(HTTPRequest var1, Map<String, String> var2);

    protected abstract HTTPResponse failedLoginResponse(HTTPRequest var1, Map<String, String> var2);

    protected HTTPResponse onSuccessfulLogin(HTTPRequest request, Map<String, String> attributes, String username, String sessionID) {
        attributes.put("username", username);
        HTTPResponse response = this.successfulLoginResponse(request, attributes);
        response.addHeaderField("Set-Cookie", "token=" + sessionID + "; HTTPOnly");
        return response;
    }

    private HTTPResponse process(HTTPRequest request, Map<String, String> attributes) {
        String username = this.login(request, attributes);
        if (username == null) {
            return this.failedLoginResponse(request, attributes);
        }
        String sessionID = this.authenticator.login(username);
        return this.onSuccessfulLogin(request, attributes, username, sessionID);
    }
}

