/*
 * Decompiled with CFR 0.152.
 */
package com.microej.android.wearos;

import android.content.Context;
import android.view.SurfaceHolder;
import androidx.wear.watchface.ComplicationSlot;
import androidx.wear.watchface.ComplicationSlotsManager;
import androidx.wear.watchface.ListenableWatchFaceService;
import androidx.wear.watchface.Renderer;
import androidx.wear.watchface.TapEvent;
import androidx.wear.watchface.WatchFace;
import androidx.wear.watchface.WatchState;
import androidx.wear.watchface.style.CurrentUserStyleRepository;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.microej.android.MicroEJSupport;
import com.microej.android.application.ApplicationDisplay;
import com.microej.android.application.ApplicationSupport;
import com.microej.android.wearos.MicroEJCanvasRenderer;
import java.lang.reflect.InvocationTargetException;

public abstract class MicroEJWatchFaceService
extends ListenableWatchFaceService {
    private MicroEJCanvasRenderer renderer;

    protected abstract String getApplicationMainClass();

    protected void runApplication() {
        String mainClassName = this.getApplicationMainClass();
        try {
            Class<?> mainClass = Class.forName(mainClassName);
            mainClass.getMethod("main", String[].class).invoke(null, new Object[]{new String[0]});
        }
        catch (InvocationTargetException e) {
            e.getCause().printStackTrace();
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            System.err.println("Error invoking main method of main class");
        }
    }

    public void onCreate() {
        super.onCreate();
        ApplicationSupport applicationSupport = MicroEJSupport.getApplicationSupport();
        applicationSupport.startup();
        applicationSupport.setContext((Context)this);
    }

    protected ListenableFuture<WatchFace> createWatchFaceFuture(SurfaceHolder surfaceHolder, WatchState watchState, ComplicationSlotsManager complicationSlotsManager, CurrentUserStyleRepository currentUserStyleRepository) {
        this.renderer = new MicroEJCanvasRenderer(surfaceHolder, currentUserStyleRepository, watchState);
        WatchFace watchface = new WatchFace(0, (Renderer)this.renderer);
        watchface.setTapListener(this.createTapListener());
        new Thread(new Runnable(){

            @Override
            public void run() {
                MicroEJWatchFaceService.this.runApplication();
            }
        }).start();
        return Futures.immediateFuture((Object)watchface);
    }

    private WatchFace.TapListener createTapListener() {
        return new WatchFace.TapListener(){

            public void onTapEvent(int tapType, TapEvent tapEvent, ComplicationSlot complicationSlot) {
                switch (tapType) {
                    case 0: {
                        MicroEJSupport.getApplicationSupport().onPointerPress((ApplicationDisplay)MicroEJWatchFaceService.this.renderer, tapEvent.getXPos(), tapEvent.getYPos());
                        break;
                    }
                    case 1: 
                    case 2: {
                        MicroEJSupport.getApplicationSupport().onPointerRelease((ApplicationDisplay)MicroEJWatchFaceService.this.renderer);
                        break;
                    }
                }
            }
        };
    }
}

