/*
 * Decompiled with CFR 0.152.
 */
package ej.bluetooth.util.services.sps;

import ej.bluetooth.BluetoothServiceDefinition;
import ej.bluetooth.BluetoothUuid;
import ej.bluetooth.util.DescriptorHelper;
import ej.bluetooth.util.ServiceHelper;

public class SerialPortConstants {
    public static final BluetoothUuid SERVICE_UUID = new BluetoothUuid("0783b03e-8535-b5a0-7140-a304d2495cb7");
    public static final BluetoothUuid TX_UUID = new BluetoothUuid("0783b03e-8535-b5a0-7140-a304d2495cb8");
    public static final BluetoothUuid RX_UUID = new BluetoothUuid("0783b03e-8535-b5a0-7140-a304d2495cba");

    private SerialPortConstants() {
    }

    public static BluetoothServiceDefinition getServiceDefinition(int securityLevel) {
        int readPermission = ServiceHelper.getReadPermission(securityLevel);
        int writePermission = ServiceHelper.getWritePermission(securityLevel);
        BluetoothServiceDefinition service = new BluetoothServiceDefinition(SERVICE_UUID);
        service.addCharacteristic(TX_UUID, 16, 0);
        service.addDescriptor(DescriptorHelper.CUD_UUID, readPermission);
        service.addDescriptor(DescriptorHelper.CCC_UUID, readPermission | writePermission);
        service.addCharacteristic(RX_UUID, 8, writePermission);
        service.addDescriptor(DescriptorHelper.CUD_UUID, readPermission);
        return service;
    }
}

