/*
 * Decompiled with CFR 0.152.
 */
package ej.bluetooth.util.services.cts;

import ej.bluetooth.BluetoothAttribute;
import ej.bluetooth.BluetoothCharacteristic;
import ej.bluetooth.BluetoothConnection;
import ej.bluetooth.BluetoothService;
import ej.bluetooth.listeners.RemoteServiceListener;
import ej.bluetooth.listeners.impl.DefaultRemoteServiceListener;
import ej.bluetooth.util.AttributeNotFoundException;
import ej.bluetooth.util.ServiceHelper;
import ej.bluetooth.util.services.cts.CurrentTimeConstants;
import ej.bon.ByteArray;
import java.util.Calendar;

public abstract class CurrentTimeClient
extends DefaultRemoteServiceListener {
    private final BluetoothConnection connection;
    private final BluetoothService service;
    private final BluetoothCharacteristic currentTimeChar;
    private final BluetoothCharacteristic localTimeInfoChar;

    public CurrentTimeClient(BluetoothConnection connection, BluetoothService service) throws AttributeNotFoundException {
        this.connection = connection;
        this.service = service;
        this.currentTimeChar = ServiceHelper.getCharacteristic(service, CurrentTimeConstants.CURRENT_TIME_UUID);
        this.localTimeInfoChar = ServiceHelper.getCharacteristic(service, CurrentTimeConstants.LOCAL_TIME_INFO_UUID);
    }

    public void start() {
        this.service.setRemoteListener((RemoteServiceListener)this);
    }

    public void stop() {
        this.service.setRemoteListener((RemoteServiceListener)new DefaultRemoteServiceListener());
    }

    public void requestTime() {
        this.connection.sendReadRequest((BluetoothAttribute)this.currentTimeChar);
        this.connection.sendReadRequest((BluetoothAttribute)this.localTimeInfoChar);
    }

    public void onReadCompleted(BluetoothConnection connection, BluetoothAttribute attribute, byte status, byte[] value) {
        if (status == 0) {
            if (attribute == this.currentTimeChar) {
                this.onCurrentTimeUpdate(CurrentTimeClient.readCurrentTime(value));
            } else if (attribute == this.localTimeInfoChar) {
                this.onLocalTimeUpdate(CurrentTimeClient.readLocalTimeOffset(value));
            }
        }
    }

    protected abstract void onCurrentTimeUpdate(long var1);

    protected abstract void onLocalTimeUpdate(long var1);

    private static long readCurrentTime(byte[] value) {
        int year = ByteArray.readShort((byte[])value, (int)0, (int)0) & 0xFFFF;
        int month = value[2] & 0xFF;
        int day = value[3] & 0xFF;
        int hour = value[4] & 0xFF;
        int minute = value[5] & 0xFF;
        int second = value[6] & 0xFF;
        int dayOfWeek = value[7] & 0xFF;
        int fractionsOfSecond = value[8] & 0xFF;
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        if (dayOfWeek == 7) {
            calendar.set(7, 1);
        } else {
            calendar.set(7, dayOfWeek + 1);
        }
        calendar.set(14, fractionsOfSecond * 1000 / 256);
        return calendar.getTimeInMillis();
    }

    private static long readLocalTimeOffset(byte[] value) {
        int timezoneOffset = value[0] & 0xFF;
        int dstOffset = value[1] & 0xFF;
        return (long)(timezoneOffset + dstOffset) * 15L * 60L * 1000L;
    }
}

