/*
 * Decompiled with CFR 0.152.
 */
package ej.bluetooth.util;

import ej.bluetooth.BluetoothUuid;

public class DescriptorHelper {
    public static final BluetoothUuid CUD_UUID = new BluetoothUuid(10497);
    public static final BluetoothUuid CCC_UUID = new BluetoothUuid(10498);
    public static final byte CUD_PERMISSIONS = 1;
    public static final byte CCC_PERMISSIONS = 9;
    private static final byte CCC_NOTIFICATIONS_FLAG = 1;
    private static final byte CCC_INDICATIONS_FLAG = 2;

    private DescriptorHelper() {
    }

    public static byte[] createCccValue(boolean notificationsEnabled, boolean indicationsEnabled) {
        int flags = 0;
        if (notificationsEnabled) {
            flags |= 1;
        }
        if (indicationsEnabled) {
            flags |= 2;
        }
        byte[] byArray = new byte[2];
        byArray[0] = (byte)flags;
        return byArray;
    }

    public static boolean checkNotificationsEnabled(byte[] value) {
        return value.length == 2 && (value[0] & 1) != 0;
    }

    public static boolean checkIndicationsEnabled(byte[] value) {
        return value.length == 2 && (value[0] & 2) != 0;
    }
}

