/**
 * Java
 *
 * Copyright 2011 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.bon;

import java.lang.ref.WeakReference;

/**
 * EnqueuedWeakReference are objects that are queued in an ReferenceQueue by the system when the
 * object they point at (see {@link java.lang.ref.Reference#get()}) is set to <code>null</code> by
 * the system. A typical use is to subclass <code>EnqueuedWeakReference</code> with classes that
 * hold native handles that need to be freed at the native level.
 */
public class EnqueuedWeakReference extends WeakReference {

	/**
	 * Creates a new <code>EnqueuedWeakReference</code>.<br>
	 * The given reference can be retrieved using {@link #get()} until the object is garbage
	 * collected. Then the method will return <code>null</code>.
	 *
	 * @param ref
	 *            object the new weak reference will refer to
	 * @param queue
	 *            the queue with which the reference is to be registered
	 */
	public EnqueuedWeakReference(Object ref, ReferenceQueue queue){
		super(null);
		throw new RuntimeException();
	}
}