/*
 * Java
 *
 * Copyright 2018-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.bluetooth.listeners.impl;

import ej.bluetooth.BluetoothAddress;
import ej.bluetooth.BluetoothConnection;
import ej.bluetooth.BluetoothService;
import ej.bluetooth.listeners.ConnectionListener;

/**
 * The <code>DefaultConnectionListener</code> class provides a default implementation of the
 * {@link ej.bluetooth.listeners.ConnectionListener} interface.
 * <p>
 * The implementation of the {@link #onConnected onConnected()} method discovers all services. The implementation of the
 * {@link #onPairRequest onPairRequest()} method rejects the pair request. The implementation of the
 * {@link #onPasskeyRequest onPasskeyRequest()} method rejects the passkey request. The implementation of each of the
 * other methods does nothing.
 */
public class DefaultConnectionListener implements ConnectionListener {

	@Override
	public void onAdvertisementCompleted() {
		throw new RuntimeException();
	}

	@Override
	public void onScanCompleted() {
		throw new RuntimeException();
	}

	@Override
	public void onScanResult(BluetoothAddress address, byte[] advertisementData, int rssi) {
		throw new RuntimeException();
	}

	@Override
	public void onConnectFailed(BluetoothAddress address) {
		throw new RuntimeException();
	}

	@Override
	public void onConnected(BluetoothConnection connection) {
		throw new RuntimeException();
	}

	@Override
	public void onDisconnected(BluetoothConnection connection) {
		throw new RuntimeException();
	}

	@Override
	public void onPairRequest(BluetoothConnection connection) {
		throw new RuntimeException();
	}

	@Override
	public void onPairCompleted(BluetoothConnection connection, boolean success) {
		throw new RuntimeException();
	}

	@Override
	public void onPasskeyRequest(BluetoothConnection connection) {
		throw new RuntimeException();
	}

	@Override
	public void onPasskeyGenerated(BluetoothConnection connection, int passkey) {
		throw new RuntimeException();
	}

	@Override
	public void onDiscoveryResult(BluetoothConnection connection, BluetoothService service) {
		throw new RuntimeException();
	}

	@Override
	public void onDiscoveryCompleted(BluetoothConnection connection) {
		throw new RuntimeException();
	}
}
