/*
 * Java
 *
 * Copyright 2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.microui.display;

/**
 * Represents a MicroUI Font.
 * <p>
 * This interface is used by several drawing methods which use a font. It can be mapped on byte array given as parameter
 * in some MicroUI natives. This byte array is retrieved in MicroEJ application using the method Font.getSNIContext().
 *
 * @see LLUIDisplay#mapMicroUIFont(byte[])
 */
public interface MicroUIFont {

	/**
	 * Gets the format of the font.
	 *
	 * @return the format
	 */
	MicroUIFontFormat getFormat();

	/**
	 * Gets the font data of the font.
	 * <p>
	 * It is the equivalent of the the byte array given when creating the Font in Java.
	 *
	 * @return the font data
	 */
	byte[] getFontData();

}
