/*
 * Java
 *
 * Copyright 2014-2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 * This document has been released and published by E-S-R consortium, a non-profit entity.
 * To learn more about E-S-R consortium, please visit http://www.e-s-r.net/.
 * The matter contained in this document is not subject to copyright; you are free to use it for any purpose, for more information see E-S-R consortium policies.
 */
package ej.microui.event;

/**
 * An event handler is intended to receive and handle events.
 * <p>
 * In the MVC pattern it is the controller.
 *
 * @since 2.0
 */
public interface EventHandler {

	/**
	 * Handles an event.
	 *
	 * @param event
	 *            the event to handle.
	 * @return <code>true</code> if the event is consumed, <code>false</code> otherwise.
	 *
	 * @see Event
	 */
	boolean handleEvent(int event);

}
