/*
 * Java
 *
 * Copyright 2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.rcommand;

import java.io.IOException;

import ej.rcommand.synchronous.RemoteCommandClient;

/**
 * The <code>RemoteNotification</code> class represents a notification sent by the {@link RemoteCommandManager} to a
 * {@link RemoteCommandClient}. Notifications may be sent by the manager without any action from the client and do not
 * expect a response or an acknowledgment.
 */
public interface RemoteNotification {

	/**
	 * Returns the name of the notification.
	 *
	 * @return the notification name.
	 */
	String getName();

	/**
	 * Writes the body of the notification using the given command sender.
	 *
	 * @param commandSender
	 *            the command sender to use to write the notification body.
	 * @throws IOException
	 *             if an exception occurs while writing the notification body.
	 */
	void writeBody(CommandSender commandSender) throws IOException;
}
