/*
 * Java
 *
 * Copyright 2019-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.library.iot.rcommand.bluetooth.commands;

import java.io.IOException;

import ej.library.iot.rcommand.bluetooth.Commands;
import ej.rcommand.CommandReader;
import ej.rcommand.CommandSender;
import ej.rcommand.synchronous.Command;

public class DisableCommand extends Command<Object> {

	@Override
	public String getName() {
		return Commands.BLUETOOTH_DISABLE;
	}

	@Override
	public void writeBody(CommandSender sender) throws IOException {
		// do nothing
	}

	@Override
	public Object readResponseInternal(CommandReader reader) throws IOException {
		return VOID_RESPONSE;
	}
}
