/*
 * Copyright 2024-2025 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package com.microej.wear.services;

/**
 * This service allows Features to get device information.
 */
public interface DeviceService {

	/**
	 * Returns the current battery level.
	 *
	 * @return the battery level (in %).
	 */
	int getBatteryLevel();

	/**
	 * Returns whether the battery is currently charging.
	 *
	 * @return <code>true</code> if the battery is charging, <code>false</code> if it is not charging.
	 */
	boolean isBatteryCharging();

	/**
	 * Returns the name of the device
	 *
	 * @return the name of the device
	 */
	String getDeviceName();

	/**
	 * Returns the Bluetooth address of the device. The address is a String following the standard Bluetooth MAC address
	 * format (e.g., {@code "00:1A:7D:DA:71:13"}).
	 *
	 * @return the Bluetooth address of the device
	 */
	String getDeviceBluetoothAddress();
}
