/*
 * Java
 *
 * Copyright 2023-2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.microui.display;

import ej.drawing.LLDWPainter.DrawingCap;

/**
 * Implementation of {@link UIDrawing} intended to be used to draw on the display and the images with the same format.
 * <p>
 * It uses the software algorithms proposed by the UI Pack except the images drawings that uses {@link LLUIPainter}
 * drawer.
 *
 * @see LLUIDisplay#getUIDrawerSoftware()
 */
public class DisplayDrawer implements UIDrawing {

	@Override
	public MicroUIImageFormat handledFormat() {
		return LLUIDisplay.Instance.getDisplayFormat();
	}

	@Override
	public void writePixel(MicroUIGraphicsContext gc, int x, int y) {
		LLUIDisplay.Instance.getUIDrawerSoftware().writePixel(gc, x, y);
	}

	@Override
	public void drawLine(MicroUIGraphicsContext gc, int x1, int y1, int x2, int y2) {
		LLUIDisplay.Instance.getUIDrawerSoftware().drawLine(gc, x1, y1, x2, y2);
	}

	@Override
	public void drawHorizontalLine(MicroUIGraphicsContext gc, int x1, int x2, int y) {
		LLUIDisplay.Instance.getUIDrawerSoftware().drawHorizontalLine(gc, x1, x2, y);
	}

	@Override
	public void drawVerticalLine(MicroUIGraphicsContext gc, int x, int y1, int y2) {
		LLUIDisplay.Instance.getUIDrawerSoftware().drawVerticalLine(gc, x, y1, y2);
	}

	@Override
	public void drawRectangle(MicroUIGraphicsContext gc, int x1, int y1, int x2, int y2) {
		LLUIDisplay.Instance.getUIDrawerSoftware().drawRectangle(gc, x1, y1, x2, y2);
	}

	@Override
	public void fillRectangle(MicroUIGraphicsContext gc, int x1, int y1, int x2, int y2) {
		LLUIDisplay.Instance.getUIDrawerSoftware().fillRectangle(gc, x1, y1, x2, y2);
	}

	@Override
	public void drawRoundedRectangle(MicroUIGraphicsContext gc, int x, int y, int width, int height, int arcWidth,
			int arcHeight) {
		LLUIDisplay.Instance.getUIDrawerSoftware().drawRoundedRectangle(gc, x, y, width, height, arcWidth, arcHeight);
	}

	@Override
	public void fillRoundedRectangle(MicroUIGraphicsContext gc, int x, int y, int width, int height, int arcWidth,
			int arcHeight) {
		LLUIDisplay.Instance.getUIDrawerSoftware().fillRoundedRectangle(gc, x, y, width, height, arcWidth, arcHeight);
	}

	@Override
	public void drawCircleArc(MicroUIGraphicsContext gc, int x, int y, int diameter, float startAngle, float arcAngle) {
		LLUIDisplay.Instance.getUIDrawerSoftware().drawCircleArc(gc, x, y, diameter, startAngle, arcAngle);
	}

	@Override
	public void drawEllipseArc(MicroUIGraphicsContext gc, int x, int y, int width, int height, float startAngle,
			float arcAngle) {
		LLUIDisplay.Instance.getUIDrawerSoftware().drawEllipseArc(gc, x, y, width, height, startAngle, arcAngle);
	}

	@Override
	public void fillCircleArc(MicroUIGraphicsContext gc, int x, int y, int diameter, float startAngle, float arcAngle) {
		LLUIDisplay.Instance.getUIDrawerSoftware().fillCircleArc(gc, x, y, diameter, startAngle, arcAngle);
	}

	@Override
	public void fillEllipseArc(MicroUIGraphicsContext gc, int x, int y, int width, int height, float startAngle,
			float arcAngle) {
		LLUIDisplay.Instance.getUIDrawerSoftware().fillEllipseArc(gc, x, y, width, height, startAngle, arcAngle);
	}

	@Override
	public void drawEllipse(MicroUIGraphicsContext gc, int x, int y, int width, int height) {
		LLUIDisplay.Instance.getUIDrawerSoftware().drawEllipse(gc, x, y, width, height);
	}

	@Override
	public void fillEllipse(MicroUIGraphicsContext gc, int x, int y, int width, int height) {
		LLUIDisplay.Instance.getUIDrawerSoftware().fillEllipse(gc, x, y, width, height);
	}

	@Override
	public void drawCircle(MicroUIGraphicsContext gc, int x, int y, int diameter) {
		LLUIDisplay.Instance.getUIDrawerSoftware().drawCircle(gc, x, y, diameter);
	}

	@Override
	public void fillCircle(MicroUIGraphicsContext gc, int x, int y, int diameter) {
		LLUIDisplay.Instance.getUIDrawerSoftware().fillCircle(gc, x, y, diameter);
	}

	@Override
	public void drawThickFadedPoint(MicroUIGraphicsContext gc, int x, int y, int thickness, int fade) {
		LLUIDisplay.Instance.getUIDrawerSoftware().drawThickFadedPoint(gc, x, y, thickness, fade);
	}

	@Override
	public void drawThickFadedLine(MicroUIGraphicsContext gc, int x1, int y1, int x2, int y2, int thickness, int fade,
			DrawingCap start, DrawingCap end) {
		LLUIDisplay.Instance.getUIDrawerSoftware().drawThickFadedLine(gc, x1, y1, x2, y2, thickness, fade, start, end);
	}

	@Override
	public void drawThickFadedCircle(MicroUIGraphicsContext gc, int x, int y, int diameter, int thickness, int fade) {
		LLUIDisplay.Instance.getUIDrawerSoftware().drawThickFadedCircle(gc, x, y, diameter, thickness, fade);
	}

	@Override
	public void drawThickFadedCircleArc(MicroUIGraphicsContext gc, int x, int y, int diameter, float startAngle,
			float arcAngle, int thickness, int fade, DrawingCap start, DrawingCap end) {
		LLUIDisplay.Instance.getUIDrawerSoftware().drawThickFadedCircleArc(gc, x, y, diameter, startAngle, arcAngle,
				thickness, fade, start, end);
	}

	@Override
	public void drawThickFadedEllipse(MicroUIGraphicsContext gc, int x, int y, int width, int height, int thickness,
			int fade) {
		LLUIDisplay.Instance.getUIDrawerSoftware().drawThickFadedEllipse(gc, x, y, width, height, thickness, fade);
	}

	@Override
	public void drawThickLine(MicroUIGraphicsContext gc, int x1, int y1, int x2, int y2, int thickness) {
		LLUIDisplay.Instance.getUIDrawerSoftware().drawThickLine(gc, x1, y1, x2, y2, thickness);
	}

	@Override
	public void drawThickCircle(MicroUIGraphicsContext gc, int x, int y, int diameter, int thickness) {
		LLUIDisplay.Instance.getUIDrawerSoftware().drawThickCircle(gc, x, y, diameter, thickness);
	}

	@Override
	public void drawThickEllipse(MicroUIGraphicsContext gc, int x, int y, int width, int height, int thickness) {
		LLUIDisplay.Instance.getUIDrawerSoftware().drawThickEllipse(gc, x, y, width, height, thickness);
	}

	@Override
	public void drawThickCircleArc(MicroUIGraphicsContext gc, int x, int y, int diameter, float startAngle,
			float arcAngle, int thickness) {
		LLUIDisplay.Instance.getUIDrawerSoftware().drawThickCircleArc(gc, x, y, diameter, startAngle, arcAngle,
				thickness);
	}

}
