/*
 * Java
 *
 * Copyright 2018-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.bluetooth.listeners.impl;

import ej.bluetooth.BluetoothAttribute;
import ej.bluetooth.BluetoothCharacteristic;
import ej.bluetooth.BluetoothConnection;
import ej.bluetooth.listeners.LocalServiceListener;

/**
 * The <code>DefaultLocalServiceListener</code> class provides a default implementation of the
 * {@link ej.bluetooth.listeners.LocalServiceListener} interface.
 * <p>
 * The implementation of the {@link #onNotificationSent onNotificationSent()} method does nothing. The implementation of
 * each of the other methods sends a response with status {@link ej.bluetooth.BluetoothStatus#REQUEST_NOT_SUPPORTED
 * REQUEST_NOT_SUPPORTED}.
 */
public class DefaultLocalServiceListener implements LocalServiceListener {

	@Override
	public void onReadRequest(BluetoothConnection connection, BluetoothAttribute attribute) {
		throw new RuntimeException();
	}

	@Override
	public void onWriteRequest(BluetoothConnection connection, BluetoothAttribute attribute, byte[] value) {
		throw new RuntimeException();
	}

	@Override
	public void onNotificationSent(BluetoothConnection connection, BluetoothCharacteristic characteristic,
			boolean success) {
		throw new RuntimeException();
	}
}
