/*
 * Copyright 2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.microvg.image.pathdata;

import ej.microvg.image.ImageGenerator.Format;

/**
 * Encodes a path with 32-bit values: the commands are encoded with 32-bit signed values and the commands' attributes
 * are encoded with 32-bit floating values.
 */
public class SingleArrayPathDataFP32 extends SingleArrayPathData {

	@Override
	public Format getFormat() {
		return Format.VG_FP32;
	}

	@Override
	public void appendCommand(int command) {
		append(command);
	}

	@Override
	public void appendCoordinate(double coordinate) {
		int i = Float.floatToIntBits((float) coordinate);
		append(i);
	}

	private void append(int i) {
		write((byte) (i));
		write((byte) (i >> 8));
		write((byte) (i >> 16));
		write((byte) (i >> 24));
	}

}
