/*
 * Java
 *
 * Copyright 2019 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.bluetooth.util.server;

import ej.bluetooth.BluetoothDevice;

/**
 * A notification callback.
 */
public interface NotificationCallback extends ReadWriteCallbackServer {

	/**
	 * Called back when a notification for the device is requested.
	 *
	 * @param device
	 *            the device to notify.
	 */
	void onNotify(BluetoothDevice device);
}
