/*
 * Java
 *
 * 2014-2022 ESR - Not subject to Copyright.
 *
 * This document has been released and published by E-S-R consortium, a non-profit entity.
 * To learn more about E-S-R consortium, please visit http://www.e-s-r.net/.
 * The matter contained in this document is not subject to copyright; you are free to use it for any purpose, for more information see E-S-R consortium policies.
 */
package ej.sni;


/**
 * A pool of resources where resources are allocated at creation time (no lazy allocation).
 */
public abstract class PoolOfLimitedReusableResources extends PoolOfReusableResources {

	/**
	 * Allocate a new pool of resources
	 *
	 * @param maxNbResources 0 (i.e. unlimited) is not allowed.
	 * @param allocationSize size of allocated resources (in bytes). 0 (i.e. unlimited) is not allowed.
	 */
	public PoolOfLimitedReusableResources(int maxNbResources, int allocationSize) {
		super(maxNbResources);
		throw new RuntimeException();
	}

	/**
	 * Return size of allocated resources (in bytes).
	 * @return size of allocated resources (in bytes).
	 */
	public int getAllocationSize() {
		throw new RuntimeException();
	}

}
