package java.lang.annotation;

/**
 * Annotation retention policy. The constants of this enumerated type describe the various policies
 * for retaining annotations. They are used in conjunction with the {@link Retention}
 * meta-annotation type to specify how long annotations are to be retained.
 */
public enum RetentionPolicy {
	/**
	 * Annotations are to be recorded in the class file by the compiler but need not be retained by the
	 * VM at run time. This is the default behavior.
	 */
	CLASS,

	/**
	 * Annotations are to be recorded in the class file by the compiler and retained by the VM at run
	 * time, so they may be read reflectively.
	 *
	 * @see java.lang.reflect.AnnotatedElement
	 */
	RUNTIME,

	/**
	 * Annotations are to be discarded by the compiler.
	 */
	SOURCE
}
