/*
 * Java
 *
 * Copyright 2021-2022 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.hoka.log;

/**
 * Server logger.
 */
public interface Logger {

	/**
	 * Log with level trace.
	 *
	 * @param msg
	 *            log message
	 */
	void trace(String msg);

	/**
	 * Log with level debug.
	 *
	 * @param msg
	 *            log message
	 */
	void debug(String msg);

	/**
	 * Log with level info.
	 *
	 * @param msg
	 *            log message
	 */
	void info(String msg);

	/**
	 * Log with level warn.
	 *
	 * @param msg
	 *            log message
	 */
	void warn(String msg);

	/**
	 * Log with level error.
	 *
	 * @param msg
	 *            log message
	 */
	void error(String msg);

	/**
	 * Log with level error.
	 *
	 * @param msg
	 *            log message
	 * @param e
	 *            error
	 */
	void error(String msg, Throwable e);

	/**
	 * Log with level error.
	 *
	 * @param e
	 *            error
	 */
	void error(Throwable e);

	/**
	 * Checks if trace is enabled.
	 *
	 * @return true if trace enabled, false otherwise
	 */
	boolean isTraceEnabled();

	/**
	 * Checks if debug is enabled.
	 *
	 * @return true if debug enabled, false otherwise
	 */
	boolean isDebugEnabled();

	/**
	 * Checks if info is enabled.
	 *
	 * @return true if info enabled, false otherwise
	 */
	boolean isInfoEnabled();

	/**
	 * Checks if warn is enabled.
	 *
	 * @return true if warn enabled, false otherwise
	 */
	boolean isWarnEnabled();

	/**
	 * Checks if error is enabled.
	 *
	 * @return true if error enabled, false otherwise
	 */
	boolean isErrorEnabled();

}
