/*
 * Copyright 2015-2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.observable;

/**
 * An observer is notified when the object it observes is changed.
 *
 * @see ej.observable.Observable
 * @see ej.observable.SimpleObservable
 */
public interface Observer {

	/**
	 * This method is called whenever the observed object is changed.
	 *
	 * @see Observable#notifyObservers()
	 * @see SimpleObservable#notifyObserver()
	 */
	void update();
}
