/*
 * Copyright 2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package com.microej.wear.components;

import ej.microui.display.GraphicsContext;

/**
 * Represents an activity.
 */
public interface Activity {

	/**
	 * Gets the name of this activity.
	 *
	 * @return the name of this activity.
	 */
	String getName();

	/**
	 * Renders the icon of this activity.
	 *
	 * @param g
	 *            the graphics context to draw with.
	 * @param x
	 *            the x coordinate of the region to draw in.
	 * @param y
	 *            the y coordinate of the region to draw in.
	 * @param size
	 *            the width and height of the region to draw in.
	 */
	void renderIcon(GraphicsContext g, int x, int y, int size);

	/**
	 * Shows this activity.
	 */
	void show();
}
