/*
 * Java
 *
 * Copyright 2022 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.microui.display;

/**
 * @see DisplayUtilities
 */
public class DisplayUtilitiesNatives {

	/**
	 * @param gc
	 *            the sni context of display's graphics context.
	 * @param flushBounds
	 *            the flush bounds destination (array of 4 elements min expected).
	 * @return true when the array has been filled, false on error (array too small, etc.).
	 * @see DisplayUtilities#getNextFlushBounds(int[])
	 */
	public static native boolean getNextFlushBounds(byte[] gc, int[] flushBounds);

	/**
	 * Returns true if the native function is now deprecated (according the UI Pack evolution). The native function is
	 * implemented (no link issue) but the result has no meaning.
	 *
	 * @param functionId
	 *            the function identifier
	 * @return true if the native function has no meaning.
	 *
	 * @see DisplayUtilities
	 */
	public static native boolean isDeprecated(int functionId);
}
