package java.lang;

/**
 * A resource that must be closed when it is no longer needed.
 */
public interface AutoCloseable {
	/**
	 * Closes this resource, relinquishing any underlying resources. This method is invoked
	 * automatically on objects managed by the {@code try}-with-resources statement.
	 * 
	 * <p>
	 * While this interface method is declared to throw {@code Exception}, implementers are
	 * <em>strongly</em> encouraged to declare concrete implementations of the {@code close} method
	 * to throw more specific exceptions, or to throw no exception at all if the close operation
	 * cannot fail.
	 * 
	 * <p>
	 * <em>Implementers of this interface are also strongly advised
	 * to not have the {@code close} method throw {@link
	 * InterruptedException}.</em>
	 * 
	 * This exception interacts with a thread's interrupted status.
	 * 
	 * <p>
	 * Note that unlike the {@link java.io.Closeable#close close} method of
	 * {@link java.io.Closeable}, this {@code close} method is <em>not</em> required to be
	 * idempotent. In other words, calling this {@code close} method more than once may have some
	 * visible side effect, unlike {@code Closeable.close} which is required to have no effect if
	 * called more than once.
	 * 
	 * However, implementers of this interface are strongly encouraged to make their {@code close}
	 * methods idempotent.
	 * 
	 * @throws Exception
	 *         if this resource cannot be closed
	 */
	void close() throws Exception;
}
