/*
 * Copyright 2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package com.microej.wear.framework.services;

/**
 * This service allows Features to get time information.
 */
public interface TimeService {

	/**
	 * Returns the current time.
	 *
	 * @return the current time (in milliseconds, measured from the Java Epoch).
	 */
	long getCurrentTime();

	/**
	 * Returns the current zone offset.
	 * <p>
	 * The zone offset can change not only when the user configures his time zone, but also at any moment depending on
	 * the time zone rules. For example, the zone offset changes when switching to summer time or winter time if the
	 * configured time zone applies DST.
	 *
	 * @return the current zone offset (in seconds, from -64800 to 64800).
	 */
	int getCurrentZoneOffset();
}
