/*
 * Java
 *
 * Copyright 2019-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.library.iot.rcommand.bluetooth.notifications;

import java.io.IOException;

import ej.library.iot.rcommand.bluetooth.Commands;
import ej.rcommand.CommandSender;
import ej.rcommand.RemoteNotification;

public class EventNotification implements RemoteNotification {

	private final byte[] event;
	private final int eventSize;

	public EventNotification(byte[] event, int eventSize) {
		this.event = event;
		this.eventSize = eventSize;
	}

	@Override
	public String getName() {
		return Commands.BLUETOOTH_EVENT;
	}

	@Override
	public void writeBody(CommandSender sender) throws IOException {
		sender.sendByteArray(this.event, 0, this.eventSize);
	}
}
