/*
 * Copyright 2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.widget.util.render;

import ej.microui.display.GraphicsContext;
import ej.microui.display.Image;
import ej.microui.display.Painter;
import ej.mwt.util.Alignment;
import ej.mwt.util.Size;

/**
 * Provides utility methods to draw images.
 */
public class ImagePainter {

	// Prevents initialization.
	private ImagePainter() {
	}

	/**
	 * Computes the optimal size of an image.
	 * <p>
	 * The given size is modified to set the optimal size.
	 *
	 * @param image
	 *            the image.
	 * @param size
	 *            the size to modify.
	 */
	public static void computeOptimalSize(Image image, Size size) {
		int width = image.getWidth();
		int height = image.getHeight();
		size.setSize(width, height);
	}

	/**
	 * Draws an image aligned in a area.
	 *
	 * @param g
	 *            the graphics context.
	 * @param image
	 *            the image.
	 * @param x
	 *            the area x coordinate.
	 * @param y
	 *            the area y coordinate.
	 * @param width
	 *            the area width.
	 * @param height
	 *            the area height.
	 * @param horizontalAlignment
	 *            the horizontal alignment.
	 * @param verticalAlignment
	 *            the vertical alignment.
	 */
	public static void drawImageInArea(GraphicsContext g, Image image, int x, int y, int width, int height,
			int horizontalAlignment, int verticalAlignment) {
		int imageX = Alignment.computeLeftX(image.getWidth(), x, width, horizontalAlignment);
		int imageY = Alignment.computeTopY(image.getHeight(), y, height, verticalAlignment);
		Painter.drawImage(g, image, imageX, imageY);
	}
}
