![](https://shields.microej.com/endpoint?url=https://repository.microej.com/packages/badges/sdk_5.7.json)
![](https://shields.microej.com/endpoint?url=https://repository.microej.com/packages/badges/arch_8.0.json)

# Overview
A service oriented architecture library. Provides dependency injection facility and runtime service registration.

## Definitions

A service is usually defined by a Java interface (but that can be a class): it is a contract between a
service provider and a service user.

It allows loose coupling between software components, the service acting as a black box hiding the complexity
of the implementations. A service can have several implementations and these implementations must fulfill
the contract of the service, hence respecting the Liskov Substitution principle ("objects in a program should
be replaceable with instances of their subtypes without altering the correctness of that program").

More information about the services can be found on the Internet with these keywords for example: service
oriented architecture, design by contract.

## Service Loader

The implementation of a service can be retrieved using `ej.service.ServiceFactory`:

    MyService serviceInstance = ServiceFactory.getService(MyService.class);

Retrieving services can be protected by a `ej.service.ServicePermission`.

## Service Registry

Services can be declared programmatically by retrieving the `ej.service.ServiceRegistry` instance then
registering an instance for a service:

    ServiceFactory.register(MyService.class, myInstance);

The service registry also allows to unregister the services:

    ServiceFactory.unregister(MyService.class, myInstance);

Registering and unregistering services can be protected by a `ej.service.ServicePermission`.

## Service Injection

Services can also be declared statically. It allows to easily change the service implementation without
modifying the Java code.

There are several ways of declaring a service:

- Defining a service property in a `xxx.properties.list` file. The key is the service fully qualified name
and the value is the implementation one.

    ej.mylib.MyService=ej.otherlib.MyServiceImplementation

The service type and implementation must also be declared in a `xxx.types.list` file. It will force the
classes to be embedded.

    ej.mylib.MyService
    ej.otherlib.MyServiceImplementation

This procedure only works in a mono-sandboxed context or in the Kernel of a multi-sandboxed context.
It won't work in a sandboxed application.

- Adding a file named with the fully qualified name of the service in the `META-INF/services` folder of
an application. The content of the file is the fully qualified name of the implementation.

# Usage
Add the following line to your `module.ivy` or your `ivy.xml`:

	<dependency org="ej.library.runtime" name="service" rev="1.2.0"/>

# Requirements

	BON-1.3, EDC-1.3

# Dependencies
_All dependencies are retrieved transitively by Ivy resolver_.

# Source
N/A

# Restrictions
None.

___
_Copyright 2014-2023 MicroEJ Corp. All rights reserved._  
_Use of this source code is governed by a BSD-style license that can be found with this software._  