/*
 * Java
 *
 * Copyright 2018 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.bluetooth.callbacks.impl;

import ej.bluetooth.BluetoothDevice;
import ej.bluetooth.callbacks.ConnectionCallbacks;

/**
 * The <code>DefaultConnectionCallbacks</code> class provides a default implementation of the
 * {@link ConnectionCallbacks} interface.
 * <p>
 * The implementation of each of the methods does nothing.
 */
public class DefaultConnectionCallbacks implements ConnectionCallbacks {

	@Override
	public void onConnectFailed(BluetoothDevice device) {
		throw new RuntimeException();
	}

	@Override
	public void onConnected(BluetoothDevice device) {
		throw new RuntimeException();
	}

	@Override
	public void onDisconnected(BluetoothDevice device) {
		throw new RuntimeException();
	}

	@Override
	public void onPairRequest(BluetoothDevice device) {
		throw new RuntimeException();
	}

	@Override
	public void onPairCompleted(BluetoothDevice device, boolean success) {
		throw new RuntimeException();
	}

	@Override
	public void onPasskeyRequest(BluetoothDevice device) {
		throw new RuntimeException();
	}

	@Override
	public void onPasskeyGenerated(BluetoothDevice device, int passkey) {
		throw new RuntimeException();
	}

	@Override
	public void onServicesDiscovered(BluetoothDevice device) {
		throw new RuntimeException();
	}
}
