/*
 * Copyright 2011-2023 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.bon;

/**
 * Signals that a method has been invoked at an illegal or inappropriate time.
 * In other words, the Java environment or Java application is not in an
 * appropriate state for the requested operation.
 */
public class IllegalStateException extends RuntimeException {

	/**
	 * Constructs an IllegalStateException with no detail message.
	 */
	public IllegalStateException() {
	}

	/**
	 * Constructs an IllegalStateException with the specified detail message.
	 *
	 * @param s
	 *            the String that contains a detailed message
	 */
	public IllegalStateException(String s) {
		super(s);
	}
}
