/*
 * Java
 *
 * Copyright 2019-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.util;

/**
 * Not in API.
 */
public class DeviceNatives {

	private DeviceNatives() {
		// private constructor
	}

	/**
	 * Fills the given buffer with the name of the architecture as a null-terminated
	 * string.
	 *
	 * @param buffer       the buffer to fill with the name of the architecture.
	 * @param bufferLength the size of the buffer.
	 * @return true on success or false on error.
	 */
	public static native boolean getArchitecture(byte[] buffer, int bufferLength);

	/**
	 * Fills the given buffer with the ID of the device.
	 *
	 * @param buffer
	 *            the buffer to fill with the ID.
	 * @param bufferLength
	 *            the size of the buffer.
	 * @return the number of bytes filled or 0 on error.
	 */
	public static native int getId(byte[] buffer, int bufferLength);

	/**
	 * Fills the given buffer with the Version of the device as a null-terminated
	 * string.
	 *
	 * @param buffer       the buffer to fill with the Version.
	 */
	public static native void getVersion(byte[] buffer);

	/**
	 * Reboots the device.
	 */
	public static native void reboot();

	/**
	 * Shutdowns the device.
	 */
	public static native void shutdown();

}
