/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt.util;

public class Alignment {
    public static final int LEFT = 0;
    public static final int HCENTER = 1;
    public static final int RIGHT = 2;
    public static final int TOP = 3;
    public static final int VCENTER = 4;
    public static final int BOTTOM = 5;

    private Alignment() {
    }

    public static void validateHorizontalAlignment(int horizontalAlignment) {
        if (!Alignment.checkHorizontalAlignment(horizontalAlignment)) {
            throw new IllegalArgumentException();
        }
    }

    public static void validateVerticalAlignment(int verticalAlignment) {
        if (!Alignment.checkVerticalAlignment(verticalAlignment)) {
            throw new IllegalArgumentException();
        }
    }

    public static boolean checkHorizontalAlignment(int horizontalAlignment) {
        switch (horizontalAlignment) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkVerticalAlignment(int verticalAlignment) {
        switch (verticalAlignment) {
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static int computeLeftX(int width, int areaX, int areaWidth, int horizontalAlignment) {
        return Alignment.computeLeftX(-(areaWidth - width), areaX, horizontalAlignment);
    }

    public static int computeTopY(int height, int areaY, int areaHeight, int verticalAlignment) {
        return Alignment.computeTopY(-(areaHeight - height), areaY, verticalAlignment);
    }

    public static int computeLeftX(int width, int anchorX, int horizontalAlignment) {
        switch (horizontalAlignment) {
            case 2: {
                return anchorX - width;
            }
            case 1: {
                return anchorX - (width >> 1);
            }
        }
        return anchorX;
    }

    public static int computeTopY(int height, int anchorY, int verticalAlignment) {
        switch (verticalAlignment) {
            case 5: {
                return anchorY - height;
            }
            case 4: {
                return anchorY - (height >> 1);
            }
        }
        return anchorY;
    }
}

