/*
 * Decompiled with CFR 0.152.
 */
package ej.websocket.frame;

import ej.websocket.Messages;
import ej.websocket.WebSocketException;
import ej.websocket.frame.ClientFrameBuilder;
import ej.websocket.frame.RawFrame;
import java.io.IOException;
import java.io.InputStream;

public class FrameScanner {
    private final InputStream is;
    private WAITING_FOR currently;

    public FrameScanner(InputStream is) {
        this.is = is;
        this.currently = WAITING_FOR.FIN_RSV_OPCODE;
    }

    public RawFrame getFrame() throws IOException, WebSocketException {
        byte finRsvOpcode = 0;
        byte maskLength = 0;
        byte[] extendedLength = null;
        int actualPayloadLength = 0;
        byte[] bytes = new byte[]{};
        while (this.currently != WAITING_FOR.COMPLETE) {
            switch (this.currently) {
                case FIN_RSV_OPCODE: {
                    finRsvOpcode = this.getByteFromStream();
                    this.currently = WAITING_FOR.MASK_AND_LENGHT;
                    break;
                }
                case MASK_AND_LENGHT: {
                    maskLength = this.mask();
                    actualPayloadLength = this.getLength(maskLength, actualPayloadLength);
                    break;
                }
                case EXTENDED_LENGTH: {
                    extendedLength = new byte[]{this.getByteFromStream(), this.getByteFromStream()};
                    actualPayloadLength = ((extendedLength[0] & 0xFF) << 8) + (extendedLength[1] & 0xFF);
                    this.currently = WAITING_FOR.PAYLOAD;
                    break;
                }
                case VERY_EXTENDED_LENGTH: {
                    throw new UnsupportedOperationException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, -4));
                }
                case MASKING_KEY: {
                    throw new UnsupportedOperationException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, -3));
                }
                case PAYLOAD: {
                    bytes = this.getPayload(finRsvOpcode, maskLength, extendedLength, actualPayloadLength);
                    this.currently = WAITING_FOR.COMPLETE;
                    break;
                }
                default: {
                    throw new IllegalStateException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, 9, new Object[]{this.currently}));
                }
            }
        }
        this.currently = WAITING_FOR.FIN_RSV_OPCODE;
        return new RawFrame(bytes);
    }

    private byte[] getPayload(byte finRsvOpcode, byte maskLength, byte[] extendedLength, int actualPayloadLength) throws IOException {
        int frameLength = ClientFrameBuilder.computeFrameLength(actualPayloadLength);
        byte[] bytes = new byte[frameLength];
        int offset = 0;
        bytes[offset] = finRsvOpcode;
        bytes[++offset] = maskLength;
        ++offset;
        if (extendedLength != null) {
            bytes[offset] = extendedLength[0];
            bytes[++offset] = extendedLength[1];
            ++offset;
        }
        int i = 0;
        while (i < actualPayloadLength) {
            byte b = this.getByteFromStream();
            bytes[offset + i] = b;
            ++i;
        }
        return bytes;
    }

    private byte mask() throws IOException {
        byte maskLength = this.getByteFromStream();
        if ((maskLength & 0x80) != 0) {
            throw new UnsupportedOperationException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, -3));
        }
        return maskLength;
    }

    private int getLength(byte maskLength, int actualPayloadLength) throws WebSocketException {
        byte payloadLength = (byte)(maskLength & 0x7F);
        if (payloadLength <= 125) {
            actualPayloadLength = payloadLength;
            this.currently = WAITING_FOR.PAYLOAD;
        } else if (payloadLength == 126) {
            this.currently = WAITING_FOR.EXTENDED_LENGTH;
        } else if (payloadLength == 127) {
            this.currently = WAITING_FOR.VERY_EXTENDED_LENGTH;
        } else {
            throw new WebSocketException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, 9));
        }
        return actualPayloadLength;
    }

    private byte getByteFromStream() throws IOException {
        int b = this.is.read();
        if (b == -1) {
            throw new IOException();
        }
        return (byte)(b & 0xFF);
    }

    private static enum WAITING_FOR {
        FIN_RSV_OPCODE,
        MASK_AND_LENGHT,
        EXTENDED_LENGTH,
        VERY_EXTENDED_LENGTH,
        MASKING_KEY,
        PAYLOAD,
        COMPLETE;

    }
}

