/*
 * Decompiled with CFR 0.152.
 */
package ej.library.iot.rcommand.bluetooth.commands;

import ej.bluetooth.BluetoothAttribute;
import ej.bluetooth.BluetoothConnection;
import ej.library.iot.rcommand.bluetooth.BluetoothController;
import ej.rcommand.CommandReader;
import ej.rcommand.CommandSender;
import ej.rcommand.synchronous.Endpoint;
import java.io.IOException;

public class SendReadRequestEndpoint
implements Endpoint {
    private final BluetoothController controller;
    private short connHandle;
    private short attributeHandle;

    public SendReadRequestEndpoint(BluetoothController controller) {
        this.controller = controller;
    }

    public String getName() {
        return "bluetooth_send_read_request";
    }

    public void readRequestBody(CommandReader reader) throws IOException {
        this.connHandle = (short)reader.readInt();
        this.attributeHandle = (short)reader.readInt();
    }

    public void writeResponseBody(CommandSender sender) throws IOException {
        BluetoothConnection connection = this.controller.getConnection(this.connHandle);
        BluetoothAttribute attribute = this.controller.getRemoteAttribute(connection, this.attributeHandle);
        if (connection != null && attribute != null && connection.sendReadRequest(attribute)) {
            sender.sendInt(0);
        } else {
            sender.sendInt(1);
        }
    }
}

