/*
 * Decompiled with CFR 0.152.
 */
package com.microej.kf.util;

import com.microej.kf.util.AbstractKFList;
import ej.kf.Feature;
import ej.kf.Kernel;
import ej.kf.Module;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class KFList<T>
extends AbstractKFList<T> {
    private final Map<Module, ArrayList<T>> featuresToLists;

    public KFList() {
        this(4);
    }

    public KFList(int initialNbContexts) {
        this.featuresToLists = new HashMap<Module, ArrayList<T>>(initialNbContexts);
    }

    @Override
    public synchronized boolean contains(Object element) {
        Map<Module, ArrayList<T>> featuresToLists = this.featuresToLists;
        Module owner = Kernel.getContextOwner();
        ArrayList<T> list = featuresToLists.get(owner);
        if (list == null) {
            return false;
        }
        return list.contains(element);
    }

    @Override
    public synchronized boolean add(T element) {
        Module owner = Kernel.getContextOwner();
        if (owner == Kernel.getInstance() && Kernel.getOwner(element) != owner) {
            throw new IllegalArgumentException();
        }
        Map<Module, ArrayList<T>> featuresToLists = this.featuresToLists;
        ArrayList<Object> list = featuresToLists.get(owner);
        if (list == null) {
            list = new ArrayList(2);
            Kernel.enter();
            try {
                featuresToLists.put(owner, list);
            }
            finally {
                Kernel.exit();
            }
        }
        return list.add(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized boolean remove(Object element) {
        ArrayList<T> list;
        Map<Module, ArrayList<T>> featuresToLists;
        Module owner = Kernel.getContextOwner();
        if (owner == Kernel.getInstance() && Kernel.getOwner((Object)element) != owner) {
            throw new IllegalArgumentException();
        }
        Map<Module, ArrayList<T>> map = featuresToLists = this.featuresToLists;
        synchronized (map) {
            list = featuresToLists.get(owner);
            if (list == null) {
                return false;
            }
        }
        boolean result = list.remove(element);
        if (!list.isEmpty()) return result;
        Kernel.enter();
        try {
            Map<Module, ArrayList<T>> map2 = featuresToLists;
            synchronized (map2) {
                featuresToLists.remove(owner);
                return result;
            }
        }
        finally {
            Kernel.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<T> iterator() {
        ArrayList<T> list;
        Map<Module, ArrayList<T>> featuresToLists = this.featuresToLists;
        if (Kernel.isInKernelMode()) {
            Collection<ArrayList<ArrayList>> subArrayValues = featuresToLists.values();
            ArrayList[] values = new ArrayList[subArrayValues.size()];
            subArrayValues.toArray(values);
            return new CompositeIterator(values);
        }
        Module owner = Kernel.getContextOwner();
        Map<Module, ArrayList<T>> map = featuresToLists;
        synchronized (map) {
            list = featuresToLists.get(owner);
        }
        if (list == null) {
            return new ArrayList(0).iterator();
        }
        return list.iterator();
    }

    @Override
    public synchronized void clear() {
        if (Kernel.isInKernelMode()) {
            this.featuresToLists.clear();
        } else {
            Module owner = Kernel.getContextOwner();
            ArrayList<T> list = this.featuresToLists.get(owner);
            if (list != null) {
                list.clear();
            }
        }
    }

    @Override
    public synchronized boolean isEmpty() {
        if (Kernel.isInKernelMode()) {
            return this.featuresToLists.isEmpty();
        }
        Module owner = Kernel.getContextOwner();
        ArrayList<T> list = this.featuresToLists.get(owner);
        if (list == null) {
            return true;
        }
        return list.isEmpty();
    }

    @Override
    public synchronized int size() {
        int size;
        if (Kernel.isInKernelMode()) {
            size = 0;
            for (ArrayList<T> subArrayValues : this.featuresToLists.values()) {
                size += subArrayValues.size();
            }
        } else {
            Module owner = Kernel.getContextOwner();
            ArrayList<T> list = this.featuresToLists.get(owner);
            size = list == null ? 0 : list.size();
        }
        return size;
    }

    @Override
    protected void toArray(ArrayList<T> allList) {
        if (Kernel.isInKernelMode()) {
            for (ArrayList<T> subArrayValues : this.featuresToLists.values()) {
                allList.addAll(subArrayValues);
            }
        } else {
            Module owner = Kernel.getContextOwner();
            ArrayList<T> list = this.featuresToLists.get(owner);
            if (list != null) {
                allList.addAll(list);
            }
        }
    }

    @Override
    protected void removeAllElementsOwnedBy(Feature feature) {
        this.featuresToLists.remove(feature);
    }

    class CompositeIterator
    implements Iterator<T> {
        private final ArrayList<T>[] subArrays;
        private Iterator<T> currentIterator;
        private int nextIteratorIndex;

        public CompositeIterator(ArrayList<T>[] subArrays) {
            this.subArrays = subArrays;
            this.nextIteratorIndex = 0;
        }

        @Override
        public boolean hasNext() {
            int nbIterators = this.subArrays.length;
            while (this.nextIteratorIndex < nbIterators) {
                if (this.currentIterator == null) {
                    this.currentIterator = this.subArrays[this.nextIteratorIndex].iterator();
                }
                if (this.currentIterator.hasNext()) {
                    return true;
                }
                this.currentIterator = null;
                ++this.nextIteratorIndex;
            }
            return false;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                return this.currentIterator.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.currentIterator == null) {
                throw new IllegalStateException();
            }
            this.currentIterator.remove();
        }
    }
}

