/*
 * Decompiled with CFR 0.152.
 */
package ej.fp.widget.display.buffer;

import ej.fp.FrontPanel;
import ej.fp.Image;
import ej.fp.Widget;
import ej.fp.widget.display.DisplayBufferManager;
import ej.fp.widget.display.buffer.DisplayBufferPolicy;
import ej.microui.display.Rectangle;

public class DirectBufferPolicy
implements DisplayBufferPolicy {
    private Widget displayWidget;
    private Image buffer;

    @Override
    public void setDisplayProperties(Widget displayWidget, int width, int height, int initialColor) {
        this.displayWidget = displayWidget;
        this.buffer = FrontPanel.getFrontPanel().newImage(width, height, initialColor, false);
    }

    @Override
    public int getBufferCount() {
        return 1;
    }

    @Override
    public boolean isDoubleBuffered() {
        return false;
    }

    @Override
    public void flush(DisplayBufferManager bufferManager, Rectangle[] rectangles) {
        this.displayWidget.repaint();
        bufferManager.simulateFlushTime();
    }

    @Override
    public Image getBackBuffer() {
        return this.buffer;
    }

    @Override
    public Image getFrontBuffer() {
        return this.buffer;
    }

    @Override
    public void dispose() {
        FrontPanel.getFrontPanel().disposeIfNotNull(new Image[]{this.buffer});
    }
}

