/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.http;

import ej.hoka.http.HTTPRequest;
import ej.hoka.http.HTTPResponse;
import ej.hoka.http.IfNoneMatchRequestHandler;
import ej.hoka.http.NotFoundRequestHandler;
import ej.hoka.http.encoding.HTTPEncodingRegistry;
import ej.hoka.http.encoding.IHTTPEncodingHandler;
import ej.hoka.http.encoding.UnsupportedHTTPEncodingException;
import ej.hoka.http.requesthandler.RequestHandler;
import ej.hoka.http.requesthandler.RequestHandlerComposite;
import ej.hoka.http.requesthandler.ResourceRequestHandler;
import ej.hoka.log.Messages;
import ej.hoka.tcp.TCPServer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import javax.net.ServerSocketFactory;

public class HTTPServer {
    private static final int BUFFER_SIZE = 4096;
    private static final String BUFFER_SIZE_PROPERTY = "hoka.buffer.size";
    private static final String HOKA_ROOT_DIRECTORY = "/hoka/";
    private static final String HTML_BR = "<br/>";
    private static final String EXCEPTION_PREFIX = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;at ";
    private static final HTTPResponse RESPONSE_INTERNAL_ERROR = HTTPResponse.createResponseFromStatus("500 Internal Server Error");
    private static final HTTPResponse RESPONSE_REQUEST_TIMEOUT = HTTPResponse.createResponseFromStatus("408 Request Timeout");
    private static final HTTPResponse RESPONSE_NOT_ACCEPTABLE = HTTPResponse.createResponseFromStatus("406 Not Acceptable");
    private final TCPServer server;
    private final int sessionJobsCount;
    private final RequestHandlerComposite rootRequestHandler;
    private final HTTPEncodingRegistry encodingRegistry;
    private Thread[] jobs;
    private boolean sendStackTraceOnException;

    public HTTPServer(int port, int maxSimultaneousConnection, int jobCount) {
        this(port, maxSimultaneousConnection, jobCount, new ResourceRequestHandler(HOKA_ROOT_DIRECTORY));
    }

    public HTTPServer(int port, int maxSimultaneousConnection, int jobCount, RequestHandler requestHandler) {
        this(new TCPServer(port, maxSimultaneousConnection), jobCount, requestHandler);
    }

    public HTTPServer(int port, int maxSimultaneousConnection, int jobCount, RequestHandler requestHandler, ServerSocketFactory serverSocketFactory) {
        this(new TCPServer(port, maxSimultaneousConnection, serverSocketFactory), jobCount, requestHandler);
    }

    public HTTPServer(int port, int maxSimultaneousConnection, int jobCount, RequestHandler requestHandler, ServerSocketFactory serverSocketFactory, int keepAliveDuration) {
        this(new TCPServer(port, maxSimultaneousConnection, serverSocketFactory, keepAliveDuration), jobCount, requestHandler);
    }

    public HTTPServer(TCPServer tcpServer, int jobCount, RequestHandler requestHandler) {
        this(tcpServer, jobCount, requestHandler, new HTTPEncodingRegistry());
    }

    public HTTPServer(TCPServer tcpServer, int jobCount, RequestHandler requestHandler, HTTPEncodingRegistry encodingRegistry) {
        this.server = tcpServer;
        if (jobCount <= 0) {
            throw new IllegalArgumentException();
        }
        this.sessionJobsCount = jobCount;
        this.rootRequestHandler = new RequestHandlerComposite();
        this.rootRequestHandler.addRequestHandler(IfNoneMatchRequestHandler.instance);
        this.rootRequestHandler.addRequestHandler(requestHandler);
        this.rootRequestHandler.addRequestHandler(NotFoundRequestHandler.instance);
        this.encodingRegistry = encodingRegistry;
        this.sendStackTraceOnException = false;
    }

    public void start() throws IOException {
        this.server.start();
        this.jobs = new Thread[this.sessionJobsCount];
        int i = this.sessionJobsCount - 1;
        while (i >= 0) {
            Thread job;
            this.jobs[i] = job = new Thread(this.newJob(), "HTTP-JOB-" + i);
            job.start();
            --i;
        }
    }

    public void stop() {
        this.server.stop();
        int i = this.jobs.length - 1;
        while (i >= 0) {
            try {
                this.jobs[i].join();
            }
            catch (InterruptedException interruptedException) {}
            --i;
        }
    }

    private Runnable newJob() {
        return new Runnable(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleConnection(Socket connection) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                BufferedInputStream inputStream = new BufferedInputStream(connection.getInputStream(), this.getBufferSize());
                try {
                    try (OutputStream outputStream = connection.getOutputStream();){
                        boolean keepAlive;
                        do {
                            String responseMessage;
                            HTTPResponse response;
                            IHTTPEncodingHandler encodingHandler;
                            block24: {
                                HTTPRequest request = null;
                                encodingHandler = null;
                                try {
                                    try {
                                        request = new HTTPRequest(inputStream, this.encodingRegistry);
                                        response = this.rootRequestHandler.process(request, new HashMap<String, String>());
                                        encodingHandler = this.encodingRegistry.getEncodingHandler(request.getHeaderField("accept-encoding"));
                                        String requestConnectionHeader = request.getHeaderField("connection");
                                        String responseConnectionHeader = response.getHeaderField("connection");
                                        keepAlive = "keep-alive".equalsIgnoreCase(requestConnectionHeader) && !"close".equalsIgnoreCase(responseConnectionHeader);
                                        responseMessage = request.getURI();
                                    }
                                    catch (IllegalArgumentException e) {
                                        responseMessage = e.getMessage();
                                        response = HTTPResponse.createError("400 Bad Request", responseMessage);
                                        keepAlive = request != null && request.getHeaderField("connection").equalsIgnoreCase("keep-alive");
                                        keepAlive = false;
                                        break block24;
                                    }
                                    catch (UnsupportedHTTPEncodingException e) {
                                        responseMessage = e.getMessage();
                                        response = HTTPResponse.createError("501 Not Implemented", responseMessage);
                                        keepAlive = request != null && request.getHeaderField("connection").equalsIgnoreCase("keep-alive");
                                        keepAlive = false;
                                        break block24;
                                    }
                                    catch (SocketTimeoutException socketTimeoutException) {
                                        responseMessage = "";
                                        response = RESPONSE_REQUEST_TIMEOUT;
                                        keepAlive = false;
                                        keepAlive = false;
                                        break block24;
                                    }
                                    catch (IOException e) {
                                        throw e;
                                    }
                                    catch (Throwable e) {
                                        responseMessage = e.getMessage();
                                        response = this.sendStackTraceOnException ? HTTPResponse.createError("500 Internal Server Error", HTTPServer.getHtmlExceptionStackTrace(e)) : RESPONSE_INTERNAL_ERROR;
                                        keepAlive = false;
                                        keepAlive = false;
                                        break block24;
                                    }
                                }
                                catch (Throwable throwable2) {
                                    keepAlive = false;
                                    throw throwable2;
                                }
                                keepAlive = false;
                            }
                            String connectionHeader = keepAlive ? "keep-alive" : "close";
                            response.addHeaderField("connection", connectionHeader);
                            String status = response.getStatus();
                            Messages.LOGGER.log(status.equals("200 OK") ? (char)'F' : (status.equals("500 Internal Server Error") ? (char)'S' : 'I'), "Hoka", 5, new Object[]{connection.hashCode(), connection.getInetAddress().toString(), status, responseMessage});
                            response.sendResponse(outputStream, encodingHandler, this.encodingRegistry, this.getBufferSize());
                        } while (keepAlive);
                    }
                    if (inputStream == null) return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (inputStream == null) throw throwable;
                    ((InputStream)inputStream).close();
                    throw throwable;
                }
                ((InputStream)inputStream).close();
                return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (IOException iOException) {
            Messages.LOGGER.log('I', "Hoka", 6, new Object[]{connection.hashCode(), connection.getInetAddress().toString()});
        }
    }

    private int getBufferSize() {
        return Integer.getInteger(BUFFER_SIZE_PROPERTY, 4096);
    }

    public boolean getSendStackTraceOnException() {
        return this.sendStackTraceOnException;
    }

    public void sendStackTraceOnException(boolean sendStackTraceOnException) {
        this.sendStackTraceOnException = sendStackTraceOnException;
    }

    private static String getHtmlExceptionStackTrace(Throwable t) {
        StringBuilder fullMessageBuilder = new StringBuilder();
        String message = t.getMessage();
        if (message != null) {
            fullMessageBuilder.append(message);
            fullMessageBuilder.append(HTML_BR);
        }
        StackTraceElement[] stackTrace = t.getStackTrace();
        int i = 0;
        String className = "java.lang";
        while (i < stackTrace.length && stackTrace[i].getClassName().startsWith(className)) {
            ++i;
        }
        className = HTTPServer.class.getName();
        if (i > 0 && i - 1 < stackTrace.length) {
            fullMessageBuilder.append(stackTrace[i - 1].toString()).append(HTML_BR);
        }
        while (i < stackTrace.length && !stackTrace[i].getClassName().equals(className)) {
            fullMessageBuilder.append(EXCEPTION_PREFIX).append(stackTrace[i].toString()).append(HTML_BR);
            ++i;
        }
        return fullMessageBuilder.toString();
    }

    static /* synthetic */ TCPServer access$0(HTTPServer hTTPServer) {
        return hTTPServer.server;
    }

    static /* synthetic */ void access$1(HTTPServer hTTPServer, Socket socket) {
        hTTPServer.handleConnection(socket);
    }
}

